

package gov.va.med.cds.persistence.hibernate;


import gov.va.med.cds.persistence.JNDIDataSourceBindingsLocatorInterface;
import gov.va.med.cds.persistence.PersistenceManagerInterface;
import gov.va.med.cds.persistence.QueryStrategyInterface;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.transaction.WorkManagerInterface;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.naming.Binding;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Required;

import commonj.work.WorkManager;


/**
 * 
 * @author vhaislthummp
 *
 */
public class FailingSiteSpecificHibernateReadPersistenceManagerFactory
{

    private Log logger = LogFactory.getLog( FailingSiteSpecificHibernateReadPersistenceManagerFactory.class );

    private Map<String, SpringHibernateLocalSessionFactoryPropertyHolder> propertyHolderMap;
    private JNDIDataSourceBindingsLocatorInterface dataSourceBindingsLocator;
    private List<BooleanRuleInterface> rules;
    protected Map<String, QueryStrategyInterface> templateQueryStrategyMap;
    protected Class<?> pointInTimeUserTypeName;
    private WorkManagerInterface queryThreadWorkManager;
    private String managerIdentifierFormat;


    public Collection<PersistenceManagerInterface> create( )
        throws Exception
    {
        Collection<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        Collection<Binding> dataSourceBindings = dataSourceBindingsLocator.getDataSourceBindings();
        for ( Binding binding : dataSourceBindings )
        {
            FailingSiteSpecificHibernateReadPersistenceManager persistenceManager = createNewPersistenceManager( binding.getName() );
            Map<String, SessionFactory> newSessionFactoryMap = createNewSessionFactoryMap( ( DataSource )binding.getObject() );
            persistenceManager.setSessionFactoryMap( newSessionFactoryMap );
            persistenceManagers.add( persistenceManager );
        }
        return persistenceManagers;
    }


    /**
     * Sets the session factory map with maps template identifiers to session factory instances.
     * 
     * @param sessionFactoryMap session factory passed in from spring injection.
    */
    @Required
    final public void setSessionFactoryPropertyHolderMap( Map<String, SpringHibernateLocalSessionFactoryPropertyHolder> propertyHolderMap )
    {
        this.propertyHolderMap = propertyHolderMap;
    }


    @Required
    final public void setDataSourceBindingsLocator( JNDIDataSourceBindingsLocatorInterface dataSourcesLocator )
    {
        this.dataSourceBindingsLocator = dataSourcesLocator;
    }


    /**
     * Sets the rules that govern the behavior of the isApplicable method.
     * @param rules The rules to evaluate.
     */
    @Required
    public void setRules( List<BooleanRuleInterface> rules )
    {
        this.rules = rules;
    }


    /**
     * 
     * @param templateQueryStrategyMap
     */
    @Required
    public void setTemplateQueryStrategyMap( Map<String, QueryStrategyInterface> templateQueryStrategyMap )
    {
        this.templateQueryStrategyMap = templateQueryStrategyMap;
    }

    @Required
    public void setQueryThreadWorkManager( WorkManagerInterface queryThreadWorkManager )
    {
        this.queryThreadWorkManager = queryThreadWorkManager;
    }

    @Required
    public void setPointInTimeUserType( Class<?> pointInTimeUserType )
        throws ClassNotFoundException
    {
        this.pointInTimeUserTypeName = pointInTimeUserType;
    }


    /**
     * Sets the manager idetifier for the persistence manager.
     * 
     * @param managerIdentifier The identifier.
     */
    @Required
    public void setManagerIdentifierFormat( String managerIdentifier )
    {
        this.managerIdentifierFormat = managerIdentifier;
    }


    private Map<String, SessionFactory> createNewSessionFactoryMap( DataSource dataSource )
        throws Exception
    {
        Map<String, SessionFactory> newMap = new HashMap<String, SessionFactory>();
        for ( Map.Entry<String, SpringHibernateLocalSessionFactoryPropertyHolder> entry : this.propertyHolderMap.entrySet() )
        {
            SpringHibernateLocalSessionFactoryPropertyHolder curPropertyHolder = entry.getValue();
            org.springframework.orm.hibernate3.LocalSessionFactoryBean newFactory = new org.springframework.orm.hibernate3.LocalSessionFactoryBean();
            newFactory.setMappingResources( curPropertyHolder.getMappingResources() );
            newFactory.setHibernateProperties( curPropertyHolder.getHibernateProperties() );
            newFactory.setDataSource( dataSource );

            newFactory.afterPropertiesSet();
            SessionFactory sessionFactory = newFactory.getObject();
            newMap.put( entry.getKey(), sessionFactory );
        }
        return newMap;

    }


    private FailingSiteSpecificHibernateReadPersistenceManager createNewPersistenceManager( String name )
        throws ClassNotFoundException
    {
        FailingSiteSpecificHibernateReadPersistenceManager persistenceManager = new FailingSiteSpecificHibernateReadPersistenceManager();
        String managerIdentifier = MessageFormat.format( this.managerIdentifierFormat, name );
        persistenceManager.setManagerIdentifier( managerIdentifier );
        persistenceManager.setPointInTimeUserType( this.pointInTimeUserTypeName );
        persistenceManager.setRules( this.rules );
        persistenceManager.setSiteIdentifier( name );
        persistenceManager.setTemplateQueryStrategyMap( this.templateQueryStrategyMap );
        persistenceManager.setQueryThreadWorkManager( this.queryThreadWorkManager );
       // if ( logger.isInfoEnabled() )
        //{
          //  logger.info( "Created site specific persistence Manager:" + " siteId=" + name + " managerIdentifier=" + managerIdentifier );
        //}
        if(logger.isInfoEnabled())
        {
            String msg = "Created site specific persistence Manager:" + " siteId=" + name + " managerIdentifier=" + managerIdentifier;

            logger.info( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, null, msg ), null );
        }
        return persistenceManager;
    }
}
