

package gov.va.med.cds.integration.vim.dbq;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.template.TemplateHelper;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.DBQQuestionnaireResultBuilder;
import gov.va.med.cds.testharness.vhim400.builders.DBQQuestionnaireResultBuilderFactory;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndCreateUpdateQuestionnaireResultTest
    extends
        AbstractEndToEndTest
{

    private static final String CLIENT_NAME = "JUnit Test Client";
    private static final String PATIENTIDENTITY_HDR = "test_sourceid_0000";
    protected static String ASSIGNINGFACILITY1 = "200HD";
    protected static String PATIENTIDENTITY2 = "1";
    protected static String ASSIGNINGFACILITY2 = "578";
    protected static String ASSIGNINGAUTHORITY = "USVHA";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    protected static String RECORDIDENTIFIER1 = "6";
    protected static String NAMESPACEID1 = "578";
    protected static final String QUERY_TIMOUT_SECONDS_MIN = "1";
    protected static final String QUERY_TIMOUT_SECONDS_MAX = "300";
    protected TemplateRequestProcessor requestProcessor;

    protected static String DOMAINENTRYPOINT_XPATH = "//questionnaireResult";
    protected static String QUESTIONNAIRE_RESULT_XPATH = "/clinicaldata:ClinicalData/patients/patient/questionnaireResults/questionnaireResult";
    protected static String CREATED_QUESTIONNAIRE_RESULT_RECORD_IDENTIFIER_XPATH = "/clinicaldata:ClinicalData/identifiers/identifier/recordIdentifier/identity";
    protected static String CREATED_QUESTIONNAIRE_RESULT_INVALID_XPATH = "/clinicaldata:ClinicalData/errorSection/fatalErrors/exception";
    protected static String UPDATED_QUESTIONNAIRE_RESULT_VALUE_XPATH = "/clinicaldata:ClinicalData/errorSection/fatalErrors/exception";


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforePatientContactLogJournalEntryTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testCreateDBQCreate1Single( )
        throws Exception
    {
        String createRequestXml = createQuestionnaireResultXml( PATIENTIDENTITY_HDR, ASSIGNINGFACILITY1, ASSIGNINGAUTHORITY,
                        DomainEntryPoint.QuestionnaireResult.getName(), TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, null, 1, true );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, createRequestXml );

        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( CREATED_QUESTIONNAIRE_RESULT_RECORD_IDENTIFIER_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCreateDBQCreate2Single( )
        throws Exception
    {
        String createRequestXml = createQuestionnaireResultXml( PATIENTIDENTITY_HDR, ASSIGNINGFACILITY1, ASSIGNINGAUTHORITY,
                        DomainEntryPoint.QuestionnaireResult.getName(), TemplateIdHelper.DBQ_CREATE2_TEMPLATE_ID, null, 1, false );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.DBQ_CREATE2_TEMPLATE_ID, createRequestXml );

        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( CREATED_QUESTIONNAIRE_RESULT_RECORD_IDENTIFIER_XPATH );
        assertTrue( recordIdentifierList.size() == 1 );
    }


    protected String createQuestionnaireResultXml( String pid, String pidAssignFac, String pidAssignAuth, String entryPoint, String templateId,
                    String recordIdentifier, int count, boolean asCDATA )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( templateId, DomainEntryPoint.QuestionnaireResult );
        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        DBQQuestionnaireResultBuilderFactory factory = new DBQQuestionnaireResultBuilderFactory();
        factory.setBuilder( new DBQQuestionnaireResultBuilder(asCDATA) );
        domainEntryPointsWrappersMap.put( "QuestionnaireResult", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = null;
        if ( pid == null )
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "patient" );
        }
        else
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", pid, pidAssignFac, pidAssignAuth );
        }
        
        Element patientDateOfBirth = DocumentHelper.createElement("dateOfBirth");
        patientDateOfBirth.setText("1979-07-04");
        patient.add(patientDateOfBirth);

        Document vdmClinicalDataInsert = clinicalDataBuilder.createClinicalData( templateId, count, patient );
        clinicalDataBuilder.addAuditInfo( vdmClinicalDataInsert.getRootElement(), CLIENT_NAME );
        return vdmClinicalDataInsert.asXML();
    }

    @SuppressWarnings( "unchecked" )
    protected Document createAndAssertDomainData( String templateId, String updateRequestXml )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.createClinicalData( updateRequestXml, templateId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for an empty error section
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        Element errorSection = errorSections.get( 0 );
        assertTrue( errorSection.content().size() == 0 );

        // Check for recordIdentifier elements
        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( CREATED_QUESTIONNAIRE_RESULT_RECORD_IDENTIFIER_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter,
                    String filterId, String entryPointXpath )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( entryPointXpath );
        assertTrue( domainElements.size() > 0 );

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_RESOLVED_IDENTIFIERS );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String mapAssigningFacility = resultsResolvedIdentifiers.element( "assigningFacility" ).getText();
            assertTrue( assigningFacilityAndPatientIdentityMap.containsKey( mapAssigningFacility ) );

            String mapIdentity = assigningFacilityAndPatientIdentityMap.get( mapAssigningFacility );
            assertTrue( ( resultsResolvedIdentifiers.element( "identity" ).getText() ).equals( mapIdentity ) );
        }

        return clinicalDataDocument;
    }


    protected String createDBQSinglePatientListDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap, String entryPoint,
                    String assigningAuthority, String filterId, String documentClassValue, String[] documentTypeValues )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createClientName( "clientName", CLIENT_NAME ) );
        element.add( FilterBuilder.createClientRequestInitiationTime( "clientRequestInitiationTime",
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, null, null, documentClassValue,
                        documentTypeValues, "ID_1", null ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }

}
