

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/exceptionHandlingConfigContext.xml" } )
public class FailingCDS2xServiceTest
    extends
        AbstractEndToEndTest
{
    private static String QUERY_NAME_BASE = "OMP-Standardized";
    private static String PATIENTIDENTITY1 = "100839"; // ACTIVE patient
    private static String ASSIGNINGFACILITY1 = "580";
    private static String XPATH_NONVAMEDICATIONEVENTS = "//patient/nonVaMedicationEvents/nonVaMedicationEvent";
    private static String ASSIGNINGAUTHORITY = "USVHA";
    private static String DOMAIN_ENTRY_POINT = "OutpatientMedicationPromise";
    protected static TemplateRequestProcessor requestProcessor;
    protected static String XPATH_ERRORSECTION = "/clinicaldata:ClinicalData/errorSection";
    protected static String XPATH_DOMAINENTRYPOINT = "//outpatientMedicationPromises";


    @BeforeTestsOnce
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractRequestValidationTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testCDS2xFailure( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNINGAUTHORITY );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY1 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createOutpatientPharmacySinglePatientDataFilter( TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, entryPointFilterMap,
                        resolvedPatientsList, null );
        Document clinicalDataDocument = readAndAssertDomainData( TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.OUTPATIENTPHARMACY_SINGLE_PATIENT_ALL_DATA_FILTER );
        assertEquals( 0, clinicalDataDocument.selectNodes( XPATH_NONVAMEDICATIONEVENTS ).size() );

        clinicalDataDocument = createAndAssertClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.OUTPATIENTPHARMACY_SINGLE_PATIENT_ALL_DATA_FILTER );
        assertEquals( 0, clinicalDataDocument.selectNodes( XPATH_NONVAMEDICATIONEVENTS ).size() );

        clinicalDataDocument = appendAndAssertClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.OUTPATIENTPHARMACY_SINGLE_PATIENT_ALL_DATA_FILTER );
        assertEquals( 0, clinicalDataDocument.selectNodes( XPATH_NONVAMEDICATIONEVENTS ).size() );

        clinicalDataDocument = updateAndAssertClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.OUTPATIENTPHARMACY_SINGLE_PATIENT_ALL_DATA_FILTER );
        assertEquals( 0, clinicalDataDocument.selectNodes( XPATH_NONVAMEDICATIONEVENTS ).size() );

        clinicalDataDocument = deleteAndAssertClinicalData( TemplateIdHelper.PHARMACY_DELETE_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.OUTPATIENTPHARMACY_SINGLE_PATIENT_ALL_DATA_FILTER );
        assertEquals( 0, clinicalDataDocument.selectNodes( XPATH_NONVAMEDICATIONEVENTS ).size() );
    }


    protected String createOutpatientPharmacySinglePatientDataFilter( String filterId, Map<String, String> entryPointFilter,
                    List<Map<String, String>> resolvedPatients, String statusValue )
    {
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        return buildOutpatientPharmacyFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients, statusValue );
    }


    public static String buildOutpatientPharmacyFilterWithResolvedIdentfiers( String filterId, List<Map<String, String>> entryPointFilterMaps,
                    List<Map<String, String>> resolvedPatients, String statusValue )
    {
        Element filter = buildOutpatientPharmacyFilterElementWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients, statusValue );
        return filter.asXML();
    }


    public static Element buildOutpatientPharmacyFilterElementWithResolvedIdentfiers( String filterId,
                    List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String statusValue )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();

        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatientWithResolvedIdentifiers( "patients", resolvedPatients ) );

        for ( Map<String, String> entryFilterMap : entryPointFilterMaps )
        {
            String domainEntryPoint = entryFilterMap.get( FilterBuilder.DOMAIN_ENTRYPOINT_KEY );

            String queryName = ( entryFilterMap != null ) ? ( entryFilterMap.get( FilterBuilder.QUERY_NAME_KEY ) != null ? ( String )entryFilterMap
                            .get( FilterBuilder.QUERY_NAME_KEY ) : "id_1" ) : "id_1";
            element.add( FilterBuilder.createEntryFilter( "entryPointFilter", domainEntryPoint, null, null, null, queryName, null ) );

        }

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() == 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document createAndAssertClinicalData( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.createClinicalData( "request", templateId, "requestId" );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() == 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document appendAndAssertClinicalData( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.appendClinicalData( "request", templateId, "requestId" );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() == 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document updateAndAssertClinicalData( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.updateClinicalData( "request", templateId, "requestId" );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() == 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document deleteAndAssertClinicalData( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.deleteClinicalData( "request", templateId, "requestId" );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() == 0 );

        return clinicalDataDocument;
    }
}
