

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;

import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadVitalsHdrVistaTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_HDR1 = "test_sourceid_1";
    private static final String PATIENT_IDENTITY_HDR2 = "test_sourceid_2";
    private static final String ASSIGNING_FACILITY_HDR = "605";
    private static final String ASSIGNING_AUTHORITY_HDR = "USDOD";

    private static final String PATIENT_IDENTITY_VISTA123 = "123";
    private static final String PATIENT_IDENTITY_VISTA260 = "260";
    private static final String PATIENT_IDENTITY_VISTA410 = "410";
    private static final String ASSIGNING_FACILITY_VISTA = "580";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String XPATH_ERRORSECTION = "/clinicaldata:ClinicalData/errorSection";
    private static final String XPATH_PATIENTS = "//patients";
    private static final String XPATH_PATIENT = "//patient";
    private static final String XPATH_IDENTIFIERS = "//requestedResolvedIdentifiers";
    private static final String XPATH_VITALSIGNS_OBSERVATION_EVENTS = "//vitalSignObservationEvents";

    private static final String ASSIGNING_AUTHORITY_ELEMENT_NAME = "assigningAuthority";
    private static final String ASSIGNING_FACILITY_ELEMENT_NAME = "assigningFacility";
    private static final String PATIENT_IDENTITY_ELEMENT_NAME = "identity";
    

    protected static String XPATH_DIVISION_CODE = "//division/code";
    protected static String XPATH_RECORDIDENTIFIER_IDENTITY = "//recordIdentifier/identity";
    protected static String XPATH_OBSERVATIONTIME_LITERAL = "//observationTime/literal";
    protected static String XPATH_STATUS = "//status";
    protected static String XPATH_OBSVCHAR_DISPLAYTEXT = "//observedCharacteristic/displayText";
    protected static String XPATH_HOMETELEHEALTH_VENDOR = "//homeTelehealthMonitor/vendor";
    protected static String XPATH_HOMETELEHEALTH_HOME_APPLICANCE = "//homeTelehealthMonitor/homeAppliance";
    protected static String XPATH_HOMETELEHEALTH_MESURMENT_DEVICE = "//homeTelehealthMonitor/measurementDevice";
    protected static String XPATH_OBSERVATION_VALUE = "//vitalSignObservation/value";
    protected static String XPATH_OBSERVATION_UNIT_DISPALYTEXT = "//vitalSignObservation/unit/displayText";
    protected static String XPATH_OBSERVATION_QUALIFIER_VALUE_DISPLATEXT = "//vitalSignObservation/qualifier/value/displayText";
    protected static String XPATH_RECORDSOURCE_NAMESPACEID = "//recordSource/namespaceId";

    protected TemplateRequestProcessor templateRequestProcessor;

    @Autowired
    private JdbcTemplate hdrJdbcTemplate;

    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadHdrVistaTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaVitalsRead( )
        throws Exception
    {
        String templateIds[] = { TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID };
        String filterIds[] = { TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER };

        for ( int ii = 0; ii < templateIds.length; ii++ )
        {
            String readTemplateId = templateIds[ii];
            String filterId = filterIds[ii];

            String requestId = TemplateIdHelper.getUniqueIdentifier();

            String[] hdrPatient = { ASSIGNING_AUTHORITY_HDR, ASSIGNING_FACILITY_HDR, PATIENT_IDENTITY_HDR1 };
            String[] vistaPatient5211 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA123 };
            String[] vistaPatient5212 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA260 };

            String[][] patientIdentifiers = { vistaPatient5211, vistaPatient5212, hdrPatient };

            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );

            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
            entryPointFilterMaps.add( entryPointFilterMap );

            Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
            //now apply a date range
            entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2005-03-16" );
            entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-06-30" );
            clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaVWVitalsignsRead40010( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.VW_VITAL_SINGLE_PATIENT_FILTER;

        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] hdrPatient = { ASSIGNING_AUTHORITY_HDR, ASSIGNING_FACILITY_HDR, PATIENT_IDENTITY_HDR1 };
        String[] vistaPatient5211 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA123 };
        String[] vistaPatient5212 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA260 };

        String[][] patientIdentifiers = { vistaPatient5211, vistaPatient5212, hdrPatient };

        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1950-03-16" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2050-06-30" );
        entryPointFilterMap.put( FilterBuilder.X_PATH_KEY, FilterBuilder.VITALS_XPATH );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );

        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testMHVVitalsignsRead40010( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.MHV_VITALSIGNS_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.MHV_VITAL_SINGLE_PATIENT_FILTER;

        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] hdrPatient = { "USVHA", ASSIGNING_FACILITY_HDR, PATIENT_IDENTITY_HDR2 };
        String[] vistaPatient5211 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA123 };
        String[] vistaPatient5212 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA260 };

        String[][] patientIdentifiers = { vistaPatient5211, vistaPatient5212, hdrPatient };
       
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );
        entryPointFilterMap.put( FilterBuilder.X_PATH_KEY, FilterBuilder.VITALS_XPATH );
    
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
     
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DIVISION_CODE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_RECORDIDENTIFIER_IDENTITY ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSERVATIONTIME_LITERAL ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_STATUS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSVCHAR_DISPLAYTEXT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HOMETELEHEALTH_VENDOR ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HOMETELEHEALTH_HOME_APPLICANCE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HOMETELEHEALTH_MESURMENT_DEVICE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSERVATION_VALUE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSERVATION_UNIT_DISPALYTEXT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSERVATION_QUALIFIER_VALUE_DISPLATEXT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_RECORDSOURCE_NAMESPACEID ).size() > 0 );   
        assertTrue( !clinicalDataDocument.asXML().contains("<status>E</status>"));
	    assertTrue( !clinicalDataDocument.asXML().contains("<exceptionMessage>READ_QUERY_STRATEGY_NULL_FAILURE</exceptionMessage>"));

    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVistaVitalsRead2( )
        throws Exception
    {
        String templateIds[] = { TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID, TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID };
        String filterIds[] = { TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER, TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER };

        for ( int ii = 0; ii < templateIds.length; ii++ )
        {
            String readTemplateId = templateIds[ii];
            String filterId = filterIds[ii];

            String requestId = TemplateIdHelper.getUniqueIdentifier();

            String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA410 };
            String[] hdrPatient = { ASSIGNING_AUTHORITY_HDR, ASSIGNING_FACILITY_HDR, PATIENT_IDENTITY_HDR2 };
            String[][] patientIdentifiers = { vistaPatient521, hdrPatient };
            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );

            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
            entryPointFilterMaps.add( entryPointFilterMap );

            Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHdrVitalsRead( )
        throws Exception
    {
        String templateIds[] = { TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID, TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID };
        String filterIds[] = { TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER, TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER };

        for ( int ii = 0; ii < templateIds.length; ii++ )
        {
            String readTemplateId = templateIds[ii];
            String filterId = filterIds[ii];

            String requestId = TemplateIdHelper.getUniqueIdentifier();

            String[] hdrPatient = { ASSIGNING_AUTHORITY_HDR, ASSIGNING_FACILITY_HDR, PATIENT_IDENTITY_HDR2 };
            String[][] patientIdentifiers = { hdrPatient };
            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );

            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
            entryPointFilterMaps.add( entryPointFilterMap );
            Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaVitalsRead( )
        throws Exception
    {
        String templateIds[] = { TemplateIdHelper.VITALSIGNS_READ_TEMPLATE_ID, TemplateIdHelper.VW_VITALSIGNS_READ_TEMPLATE_ID };
        String filterIds[] = { TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER, TemplateIdHelper.VITAL_SINGLE_PATIENT_ALL_DATA_FILTER };

        for ( int ii = 0; ii < templateIds.length; ii++ )
        {
            String readTemplateId = templateIds[ii];
            String filterId = filterIds[ii];

            String requestId = TemplateIdHelper.getUniqueIdentifier();

            String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA, PATIENT_IDENTITY_VISTA410 };
            String[][] patientIdentifiers = { vistaPatient521 };
            List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

            Map<String, String> entryPointFilterMap = new HashMap<String, String>();
            entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "VitalSignObservationEvent" );
            entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "testQueryName" );

            List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
            entryPointFilterMaps.add( entryPointFilterMap );

            Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
            List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
            assertTrue( errorSections.size() == 0 );
        }
    }


    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, List<Map<String, String>> entryPointFilterMaps,
                    List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );
        
        templateRequestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( clinicalDataDocument );
        String clinicalDataXml = clinicalDataDocument.asXML();
        Assert.assertXmlValidation( clinicalDataXml, templateId );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_PATIENT );
        assertTrue( domainElements.size() > 0 );

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String resultsAssigningAuthority = resultsResolvedIdentifiers.element( ASSIGNING_AUTHORITY_ELEMENT_NAME ).getText();
            String resultsAssigningFacility = resultsResolvedIdentifiers.element( ASSIGNING_FACILITY_ELEMENT_NAME ).getText();
            String resultsPatientIdentity = resultsResolvedIdentifiers.element( PATIENT_IDENTITY_ELEMENT_NAME ).getText();

            Map<String, String> assigningAuthorityFacilityAndPatientIdentityMap = null;
            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
            {
                String mapAssigningAuthority = resolvedPatientMap.get( FilterBuilder.ASSIGNING_AUTHORITY_KEY );
                String mapAssigningFacility = resolvedPatientMap.get( FilterBuilder.ASSIGNING_FACILITY );
                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
                if ( mapAssigningAuthority != null && mapAssigningAuthority.equalsIgnoreCase( resultsAssigningAuthority )
                                && mapAssigningFacility != null && mapAssigningFacility.equalsIgnoreCase( resultsAssigningFacility )
                                && mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
                {
                    assigningAuthorityFacilityAndPatientIdentityMap = resolvedPatientMap;
                    break;
                }
            }

            assertNotNull( assigningAuthorityFacilityAndPatientIdentityMap );
            String mapPatientIdentity = assigningAuthorityFacilityAndPatientIdentityMap.get( FilterBuilder.IDENTITY );
            assertNotNull( mapPatientIdentity );
            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
        }

        List<Element> vsoeElements = clinicalDataDocument.selectNodes( XPATH_VITALSIGNS_OBSERVATION_EVENTS );
        assertTrue( vsoeElements.size() > 0 );

        return clinicalDataDocument;
    }

}
