

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadOutpatientPharmacyTest
    extends
        AbstractEndToEndTest
{

    protected static final String OUTPATIENT_MEDICATION_PROMISE = "Outpatient Medication Promise";
    private static final String PATIENTIDENTITY_HDR = "test_sourceid_0000";
    private static final String PATIENTIDENTITY_HDR1 = "test_sourceid_10010";
    private static final String PATIENTIDENTITY_HDR2 = "test_sourceid_10000";
    protected static String PATIENTIDENTITY1 = "1";
    protected static String PATIENTIDENTITY100120 = "100120";
    protected static String PATIENTIDENTITY128 = "128";
    protected static String PATIENTIDENTITY123 = "123";
    protected static String PATIENTIDENTITY149 = "149";
    protected static String PATIENTIDENTITY_FAILURE_1 = "1111";
    protected static String ASSIGNINGFACILITY1 = "580";
    protected static String ASSIGNINGFACILITY_FAILURE_1 = "507";
    protected static String PATIENTIDENTITY2 = "1";
    protected static String ASSIGNINGFACILITY2 = "578";
    protected static String ASSIGNINGAUTHORITY = "USVHA";
    protected static String ASSIGNINGAUTHORITY_HDR_DOD = "USDOD";
    protected static String ASSIGNINGFACILITY3 = "605";
    private static final String ASSIGNING_FACILITY_HDR_DOD = "200CH";
    protected static String RECORDIDENTIFIER1 = "6";
    protected static String NAMESPACEID1 = "578";
    protected static final String QUERY_TIMOUT_SECONDS_MIN = "1";
    protected static final String QUERY_TIMOUT_SECONDS_MAX = "300";
    protected TemplateRequestProcessor requestProcessor;
    protected static String XPATH_OUTPATIENTMEDICATIONPROMISES = "//patient/outpatientMedicationPromises/outpatientMedicationPromise";
    protected static String XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT = "//patient/identifier/identity";
    protected static String XPATH_EXPANDEDPATIENTINSTRUCTIONS = "//expandedPatientInstructions/expandedPatientInstruction";
    protected static String XPATH_PHARMACYINSTRUCTIONS = "//pharmacyInstructions/pharmacyInstruction";
    protected static String XPATH_REFILLDISPENSES = "//refillDispense";
    protected static String XPATH_ORIGINALDISPENSES = "//originalDispense";
    protected static String XPATH_NUMBEROFREFILLSAUTHORIZED = "//numberOfRefillsAuthorized";
    protected static String XPATH_SIG = "//sig";
    protected static String XPATH_PARTIALDISPENSES = "//partialDispenses/partialDispense";
    protected static String XPATH_ACTIVITYLOGS = "//activitiesLog/activityLog";
    protected static String XPATH_MEDICATION_INSTRUCTIONS = "//medicationInstructions/medicationInstruction";
    protected static String XPATH_IC_DOMAINENTRYPOINT = "//intoleranceConditions";
    protected static String XPATH_DOMAINENTRYPOINT = "//outpatientMedicationPromises";
    protected static String XPATH_AA_DOMAINENTRYPOINT = "//allergyAssessments";
    protected static String XPATH_DRUGCLASS = "//drugClass";
    protected static String XPATH_DRUGINGREDIENT = "//drugIngredient";
    protected static String XPATH_GMRALLERGYAGENT = "//gmrAllergyAgent";
    protected static String XPATH_FACILITYIDENTIIFER = "//facilityIdentifier";
    protected static String XPATH_REACTION = "//reaction";
    protected static String XPATH_REACTION_OBSERVATION_TIME = "//reaction/observationTime";
    protected static String XPATH_INFORMATION_SOURCE_CATEGORY = "//informationSourceCategory";
    protected static String XPATH_SEVERITY_VALUE_CODE = "//severity/value/code";
    protected static String XPATH_SEVERITY_VALUE_DISPLAYTEXT = "//severity/value/displayText";
    protected static String XPATH_SEVERITY_VALUE_CODINGSYSTEM = "//severity/value/codingSystem";
    protected static String XPATH_MECHANISM_CODE = "//mechanism/code";
    protected static String XPATH_MECHANISM_DISPLAYTEXT = "//mechanism/displayText";
    protected static String XPATH_MECHANISM_CODINGSYSTEM = "//mechanism/codingSystem";
    protected static String XPATH_ALLERGY_TYPE_CODE = "//allergyType/code";
    protected static String XPATH_ALLERGY_TYPE_DISPLAYTEXT = "//allergyType/displayText";
    protected static String XPATH_ALLERGY_TYPE_CODINGSYSTEM = "//allergyType/codingSystem";
    protected static String XPATH_OBSERVATION_TIME = "//observtionTime";
    protected static String XPATH_VERIFIED = "//verified";
    protected static String XPATH_AUTHOR_TIME = "//author/time/literal";
    protected static String XPATH_AUTHOR_FAMILY_NAME = "//author/practitioner/name/family";
    protected static String XPATH_AUTHOR_GIVEN_NAME = "//author/practitioner/name/given";
    protected static String XPATH_AGENT_CODE = "//agent/code";
    protected static String XPATH_ASSESSEMENT_VALUE_CODE = "//assessmentValue/code";
    protected static String XPATH_ASSESSEMENT_VALUE_DISPLAYTEXT = "//assessmentValue/displayText";
    protected static String XPATH_ASSESSEMENT_VALUE_CODINGSYSTEM = "//assessmentValue/codingSystem";
    protected static String XPATH_PATIENTIDENTITY1 = "//patient/identifier[identity='1']";
    protected static String XPATH_HDR_DOD_ASSIGNINGFACILITY = "//patient/identifier[assigningFacility='200CH']";


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractRequestValidationTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAOutpatientPharmacyRead1( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY2, PATIENTIDENTITY1 );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilterWithTimeout( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null, "300" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap,
                        TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ACTIVITYLOGS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PARTIALDISPENSES ).size() > 0 );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAOutpatientPharmacyRead1WithStartEndDates( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY2, PATIENTIDENTITY1 );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilterWithTimeout( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01",
                        "1998-12-31", "120" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap,
                        TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ACTIVITYLOGS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PARTIALDISPENSES ).size() > 0 );
    }


    @Test
    @Suite( groups = { "timeouttest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAOutpatientPharmacyReadWithTimeout( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilterWithTimeout( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01",
                        "1998-12-31", "1" );

        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
        assertNotNull( clinicalDataDocument );
        String clinicalDataXml = clinicalDataDocument.asXML();
        Assert.assertXmlValidation( clinicalDataXml, readTemplateId );

        // Check for possible timeout error
        List<Element> errorCodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNINGS_ERRORCODE );
        if ( errorCodes.size() == 1 )
        {
            assertTrue( errorCodes.get( 0 ).getText().equals( TIMOUT_ERROR_CODE ) );
        }

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAPharmacyRead40010CancelDate( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        //start and end date same as the cancel date
        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1995-04-20", "1995-04-20" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

        //filter with no end date
        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1995-04-20", null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        
        patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

        //cancel date in between start and end date
        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1995-04-01", "1995-05-20" );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        
        patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

        //expiration date in between start and end date
        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1999-04-20", "1999-12-01" );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );             

        patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

        //expiration date same as start and end date - cancel date is not in this range
        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2000-09-21", "2000-09-21" );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        
        patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );
    }
    

    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrOutpatientPharmacyRead1( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAOutpatientPharmacyRead1( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_3X_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrPharmacyRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );
        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

    }

    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrPharmacyRead40010_CancelDate( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-04-01", "2007-04-15" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );
        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrPharmacyRead40010_NoStartDateEndDate( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );
        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAPharmacyRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01", "1998-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01", "1998-12-31" );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkData( patientsList );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAVWOutpatientPharmacyRead1( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY2, PATIENTIDENTITY1 );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01",
                        "1998-12-31" );

        Document clinicalDataDocument = readAndAssertNoDomainData( assigningFacilityAndPatientIdentityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_3X_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap, "OutpatientMedicationPromise",
                        ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertNoDomainData( assigningFacilityAndPatientIdentityMap, TemplateIdHelper.VW_PHARMACY_READ_3X_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

    }


    @Test
    @Suite( groups = { "timeouttest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAVWOutpatientPharmacyRead1WithTimeout( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.VW_PHARMACY_READ_3X_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY1, PATIENTIDENTITY1 );
        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );
        String filterXml = createOutpatientPharmacySinglePatientListDataFilterWithTimeout( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01",
                        "1998-12-31", "1" );

        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
        assertNotNull( clinicalDataDocument );
        String clinicalDataXml = clinicalDataDocument.asXML();
        Assert.assertXmlValidation( clinicalDataXml, readTemplateId );

        // Check for possible timeout error
        List<Element> errorCodes = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION_WARNINGS_ERRORCODE );
        if ( errorCodes.size() == 1 )
            assertTrue( errorCodes.get( 0 ).getText().equals( TIMOUT_ERROR_CODE ) );

        assertTrue( !clinicalDataDocument.asXML().contains( "<outpatientMedicationPromises>" ) );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVWOutpatientPharmacyDetailRead1( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );
        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_3X_DETAIL_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_3X_DETAIL_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVWPharmacyRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );
        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
    }


    @Test
    @Suite( groups = { "timeouttest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVWPharmacyRead40010WithTimeOut( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MIN );
        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAVWOutpatientPharmacyDetailRead1( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_3X_DETAIL_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkForNoVistAData( patientsList );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAVWPharmacyRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "1998-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkForNoVistAData( patientsList );

    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistAVWOutpatientPharmacyDetail1( )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNINGFACILITY2, PATIENTIDENTITY1 );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_1", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientSingleRecordDataFilter( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY, TemplateIdHelper.RX_SINGLE_PATIENT_SINGLE_RECORD_FILTER, "401611",
                        "578_52", "CPM.server123.DOMAIN.EXT", "DNS", "60" );

        Document clinicalDataDocument = readAndAssertNoDomainData( assigningFacilityAndPatientIdentityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_3X_DETAIL_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_SINGLE_RECORD_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVWPharmacyDetailRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );
        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );
        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistAVWPharmacyDetailRead40010( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );
        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, PATIENTIDENTITY1, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap,
                        TemplateIdHelper.VW_PHARMACY_READ_DETAIL_TEMPLATE_ID, filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER,
                        getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> patientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        chkForNoVistAData( patientsList );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVWOutpatientPharmacyRead1( )
        throws Exception
    {
        Map<String, String> assigningAuthorityAndFacilityMap = new HashMap<String, String>();

        assigningAuthorityAndFacilityMap.put( ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( "ID_1", "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, "2007-01-01", "2008-12-31" );

        Document clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_3X_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        List<Element> dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }

        filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningAuthorityAndFacilityMap, "OutpatientMedicationPromise",
                        PATIENTIDENTITY_HDR, null, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        clinicalDataDocument = readAndAssertDomainData( assigningAuthorityAndFacilityMap, TemplateIdHelper.VW_PHARMACY_3X_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, getOutpatientMedicationPromiseEntryPointXpath() );

        dodPatientsList = clinicalDataDocument.selectNodes( XPATH_OUTPATIENTMEDICATIONPROMISE_PATIENT );

        for ( Element dodPatient : dodPatientsList )
        {
            assertTrue( dodPatient.asXML().contains( PATIENTIDENTITY_HDR ) );
            break;
        }
    }


    //      @Test
    //      @Suite( groups = { "brokentest" } )
    //      @SuppressWarnings( "unchecked" )
    //      public void testVistaPharmacyRead40010_SingleDfnFailure( )
    //          throws Exception
    //      {
    //          String readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
    //          String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
    //          String requestId = TemplateIdHelper.getUniqueIdentifier();
    //    
    ////          String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1};
    //          String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, "100014"};
    //          String[] vistaPatient580a = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, "7"};
    //          String[][] patientIdentifiers = { vistaPatient580, vistaPatient580a };
    //          List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
    //    
    //          Map<String, String> entryPointFilterMap = new HashMap<String, String>();
    //          entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
    //          entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
    //          entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );
    //    
    //          List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
    //          entryPointFilterMaps.add( entryPointFilterMap );
    //          Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
    //    
    //          List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
    //          assertTrue( domainElements.size() > 0 );
    //      }
    @Ignore
    //@Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistaPharmacyRead40010_SingleSiteFailure( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] vistaPatient503 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_FAILURE_1 };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1996-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1996-12-31" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );

        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( readTemplateId, filterXml, filterId, requestId );
        assertNotNull( clinicalDataDocument );

        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
    }


    //      @Test
    //      @Suite( groups = { "brokentest" } )
    //      @SuppressWarnings( "unchecked" )
    //      public void testVistaPharmacyRead40010WithStartEndDates( )
    //          throws Exception
    //      {
    //          String readTemplateId = TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID;
    //          String filterId = TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER;
    //          String requestId = TemplateIdHelper.getUniqueIdentifier();
    //    
    //          String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
    //          String[][] patientIdentifiers = { vistaPatient580 };
    //          List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );
    //    
    //          Map<String, String> entryPointFilterMap = new HashMap<String, String>();
    //          entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
    //          entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
    //          entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );
    //          entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1996-01-01" );
    //          entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1996-12-31" );
    //          List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
    //          entryPointFilterMaps.add( entryPointFilterMap );
    //          
    //          Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
    //    
    //          List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
    //          assertTrue( domainElements.size() > 0 );
    //      }
    @Ignore
    //@Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistaRDIIntoleranceConditionPharmacyRead40010( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1998-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1998-12-31" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        String result = clinicalDataDocument.asXML();
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REACTION ).size() == 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SIG ).size() > 0 );

    }


    //@Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistaRDIIntoleranceConditionPharmacyRead40011( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID_40011;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient1 = {"USVHA", "605", "test_sourceid_0000"};
        String[] hdrPatient2 = {"USVHA", "605", "test_sourceid_10001"};
        
        String[][] patientIdentifiers = {  vistaPatient580, hdrPatient1, hdrPatient2 };
        
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1970-01-01" );
        //entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1970-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2014-01-01" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );

        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        String result = clinicalDataDocument.asXML();

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SIG ).size() > 0 );

    }


    @Ignore
    //@Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistaRDIIntoleranceConditionPharmacyRead40012( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID_40012;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient578 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY2, PATIENTIDENTITY1 };
        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY100120 };
        String[] hdrPatient = {"USVHA", "605", "test_sourceid_0000"};
        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580, hdrPatient };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1990-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1990-01-01" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );

        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        String result = clinicalDataDocument.asXML();

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_CODE ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_DISPLAYTEXT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_CODINGSYSTEM ).size() == 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SIG ).size() > 0 );

    }


    @Ignore
    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testVistaRDIAllergiesPharmacyRead40013( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_ALLERGIES_PHARMACY_READ_TEMPLATE_ID_40013;
        String filterId = TemplateIdHelper.RDI_ALLERGY_RX_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient578 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY2, PATIENTIDENTITY1 };
        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY100120 };
        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "1996-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "1996-12-31" );
        entryPointFilterMap.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, QUERY_TIMOUT_SECONDS_MAX );

        Map<String, String> entryPointFilterForAllergyAssessment = new HashMap<String, String>();
        entryPointFilterForAllergyAssessment.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "AllergyAssessment" );
        entryPointFilterForAllergyAssessment.put( FilterBuilder.QUERY_NAME_KEY, "AA-1" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        entryPointFilterMaps.add( entryPointFilterForAllergyAssessment );

        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );

        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        List<Element> aaDomainElements = clinicalDataDocument.selectNodes( XPATH_AA_DOMAINENTRYPOINT );
        assertTrue( aaDomainElements.size() > 0 );

        String result = clinicalDataDocument.asXML();

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_CODE ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_DISPLAYTEXT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SEVERITY_VALUE_CODINGSYSTEM ).size() == 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SIG ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_MECHANISM_CODE ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_MECHANISM_DISPLAYTEXT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_MECHANISM_CODINGSYSTEM ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ALLERGY_TYPE_CODE ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ALLERGY_TYPE_DISPLAYTEXT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ALLERGY_TYPE_CODINGSYSTEM ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_VERIFIED ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_AUTHOR_TIME ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_AUTHOR_FAMILY_NAME ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_AUTHOR_GIVEN_NAME ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ASSESSEMENT_VALUE_CODE ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ASSESSEMENT_VALUE_DISPLAYTEXT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ASSESSEMENT_VALUE_CODINGSYSTEM ).size() > 0 );

    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistaRDIIntoleranceConditionPharmacyRead40010( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-12-31" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION ).size() == 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_SIG ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistaRDIIntoleranceConditionPharmacyRead40011( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID_40011;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        // Assert content for IC
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );

        // Assert content for OP
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_SIG ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistaRDIIntoleranceConditionPharmacyRead40012( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID_40012;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-12-31" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );

        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_CODE ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_DISPLAYTEXT ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_CODINGSYSTEM ).size() == 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_SIG ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }

//marking broken - not reading RDI from VISTA
    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrVistaRDIAllergiesPharmacyRead40013( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_ALLERGIES_PHARMACY_READ_TEMPLATE_ID_40013;
        String filterId = TemplateIdHelper.RDI_ALLERGY_RX_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR2 };
        String[] hdrPatient1000 = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD, hdrPatient1000 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-12-31" );

        Map<String, String> entryPointFilterForAllergyAssessment = new HashMap<String, String>();
        entryPointFilterForAllergyAssessment.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "AllergyAssessment" );
        entryPointFilterForAllergyAssessment.put( FilterBuilder.QUERY_NAME_KEY, "AA-1" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        entryPointFilterMaps.add( entryPointFilterForAllergyAssessment );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        List<Element> aaDomainElements = clinicalDataDocument.selectNodes( XPATH_AA_DOMAINENTRYPOINT );
        //assertTrue( aaDomainElements.size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION_OBSERVATION_TIME ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_AGENT_CODE ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_CODE ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_DISPLAYTEXT ).size() > 0 );
        //        assertTrue( clinicalDataDocument.selectNodes( XPATH_SEVERITY_VALUE_CODINGSYSTEM ).size() == 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_SIG ).size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_MECHANISM_CODE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_MECHANISM_DISPLAYTEXT ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_MECHANISM_CODINGSYSTEM ).size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_ALLERGY_TYPE_CODE ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ALLERGY_TYPE_DISPLAYTEXT ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_ALLERGY_TYPE_CODINGSYSTEM ).size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_VERIFIED ).size() > 0 );

        //assertTrue( clinicalDataDocument.selectNodes( XPATH_AUTHOR_TIME ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_AUTHOR_FAMILY_NAME ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_AUTHOR_GIVEN_NAME ).size() > 0 );

        //assertTrue( clinicalDataDocument.selectNodes( XPATH_OBSERVATION_TIME ).size() > 0 );

        //assertTrue( clinicalDataDocument.selectNodes( XPATH_ASSESSEMENT_VALUE_CODE ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_ASSESSEMENT_VALUE_DISPLAYTEXT ).size() > 0 );
        //assertTrue( clinicalDataDocument.selectNodes( XPATH_ASSESSEMENT_VALUE_CODINGSYSTEM ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrOnlyRDIIntoleranceConditionPharmacyRead40010( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR1 };
        String[] hdrPatient1000 = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD, hdrPatient1000 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-12-31" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_REACTION ).size() == 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() == 0 );

        assertTrue( clinicalDataDocument.selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( clinicalDataDocument.selectNodes( XPATH_SIG ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    @SuppressWarnings( "unchecked" )
    public void testHdrOnlyRDIIntoleranceConditionPharmacyRead40011( )
        throws Exception
    {
        String readTemplateId = TemplateIdHelper.RDI_INTOLERANCE_CONDITION_PHARMACY_READ_TEMPLATE_ID_40011;
        String filterId = TemplateIdHelper.RDI_IC_RX_CANNED_FILTER_ID;
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        String[] vistaPatient580 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY1, PATIENTIDENTITY1 };
        String[] hdrPatient0000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR };
        String[] hdrPatient0000USDOD = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR };
        String[] hdrPatient10000 = { ASSIGNINGAUTHORITY, ASSIGNINGFACILITY3, PATIENTIDENTITY_HDR1 };
        String[] hdrPatient1000 = { ASSIGNINGAUTHORITY_HDR_DOD, ASSIGNING_FACILITY_HDR_DOD, PATIENTIDENTITY_HDR1 };
        String[][] patientIdentifiers = { vistaPatient580, hdrPatient0000, hdrPatient10000, hdrPatient0000USDOD, hdrPatient1000 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterForIntoleranceCondition = new HashMap<String, String>();
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "IntoleranceCondition" );
        entryPointFilterForIntoleranceCondition.put( FilterBuilder.QUERY_NAME_KEY, "IC-1" );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "OutpatientMedicationPromise" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "ID_1" );
        entryPointFilterMap.put( FilterBuilder.START_DATE_KEY, "2007-01-01" );
        entryPointFilterMap.put( FilterBuilder.END_DATE_KEY, "2007-12-31" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        entryPointFilterMaps.add( entryPointFilterForIntoleranceCondition );
        Document clinicalDataDocument = readAndAssertDomainData( readTemplateId, filterId, requestId, entryPointFilterMaps, resolvedPatients );
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        List<Element> icDomainElements = clinicalDataDocument.selectNodes( XPATH_IC_DOMAINENTRYPOINT );
        assertTrue( icDomainElements.size() > 0 );

        String result = clinicalDataDocument.asXML();

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGCLASS ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_DRUGINGREDIENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_GMRALLERGYAGENT ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_FACILITYIDENTIIFER ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REACTION ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_INFORMATION_SOURCE_CATEGORY ).size() > 0 );

        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_REFILLDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_ORIGINALDISPENSES ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_NUMBEROFREFILLSAUTHORIZED ).size() > 0 );
        assertTrue( DocumentHelper.parseText( result ).selectNodes( XPATH_SIG ).size() > 0 );

        // Assert CHDR content
        assertTrue( clinicalDataDocument.selectNodes( XPATH_HDR_DOD_ASSIGNINGFACILITY ).size() > 0 );

        // Assert no VistA data in the response
        assertTrue( clinicalDataDocument.selectNodes( XPATH_PATIENTIDENTITY1 ).size() == 0 );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter,
                    String filterId, String entryPointXpath )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( XPATH_DOMAINENTRYPOINT );
        assertTrue( domainElements.size() > 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertNoDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter,
                    String filterId, String entryPointXpath )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        assertTrue( !clinicalDataDocument.asXML().contains( "<outpatientMedicationPromises>" ) );

        return clinicalDataDocument;
    }


    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, List<Map<String, String>> entryPointFilterMaps,
                    List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );

        assertNotNull( clinicalDataDocument );

        String clinicalDataXml = clinicalDataDocument.asXML();

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        return clinicalDataDocument;
    }


    protected Document readAndAssertNoDomainData( String templateId, String filterId, String requestId,
                    List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( clinicalDataDocument );

        String clinicalDataXml = clinicalDataDocument.asXML();

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        assertTrue( !clinicalDataDocument.asXML().contains( "<outpatientMedicationPromises>" ) );

        return clinicalDataDocument;
    }


    private void chkData( List<Element> patientsList )
    {
        int hdrCounter = 0;
        int vistACounter = 0;
        for ( Element patient : patientsList )
        {
            if ( !patient.asXML().contains( PATIENTIDENTITY_HDR ) )
            {
                if ( vistACounter >= 1 )
                {
                    continue;
                }
                else
                {
                    assertTrue( patient.asXML().contains( PATIENTIDENTITY1 ) );
                    vistACounter++ ;
                }
            }
            else
            {
                if ( hdrCounter >= 1 )
                {
                    continue;
                }
                else
                {
                    assertTrue( patient.asXML().contains( PATIENTIDENTITY_HDR ) );
                    hdrCounter++ ;
                }
            }

            if ( hdrCounter == 1 && vistACounter == 1 )
            {
                break;
            }
        }
    }


    private void chkForNoVistAData( List<Element> patientsList )
    {
        int hdrCounter = 0;

        if ( patientsList.contains( PATIENTIDENTITY1 ) )
        {
            Assert.fail( "VW data cannot have Vista data" );
        }
        for ( Element patient : patientsList )
        {
            if ( patient.asXML().contains( PATIENTIDENTITY_HDR ) )
            {
                if ( hdrCounter >= 1 )
                {
                    continue;
                }
                else
                {
                    assertTrue( patient.asXML().contains( PATIENTIDENTITY_HDR ) );
                    hdrCounter++ ;
                }
            }

            if ( hdrCounter == 1 )
            {
                break;
            }
        }
    }


    protected String createOutpatientPharmacySinglePatientListDataFilter( Map<String, String> assigningAuthorityAndFacilityMap, String entryPoint,
                    String dodPatient, String vistAPatient, String filterId, String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createClientName( "clientName", "testClientName" ) );
        element.add( FilterBuilder.createClientRequestInitiationTime( "clientRequestInitiationTime",
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ) );
        element.add( FilterBuilder.createPatient( "patients", dodPatient, vistAPatient, assigningAuthorityAndFacilityMap ) );
        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, startDate,
                        endDate, "ID_1" ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createOutpatientPharmacySinglePatientListDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String entryPoint, String assigningAuthority, String filterId, String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithAdditionalParameters( "entryPointFilter", entryPoint, startDate,
                        endDate, "ID_1" ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createOutpatientPharmacySinglePatientListDataFilterWithTimeout( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String entryPoint, String assigningAuthority, String filterId, String startDate, String endDate, String queryTimeoutSeconds )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithAdditionalParametersAndTimeout( "entryPointFilter", entryPoint,
                        startDate, endDate, "ID_1", queryTimeoutSeconds ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String createOutpatientPharmacySinglePatientSingleRecordDataFilter( Map<String, String> assigningFacilityAndPatientIdentityMap,
                    String entryPoint, String assigningAuthority, String filterId, String identity, String namespaceId, String universalId,
                    String universalIdType, String queryTimeoutSeconds )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createPatient( "patients", assigningAuthority, assigningFacilityAndPatientIdentityMap ) );

        element.add( FilterBuilder.createOutpatientMedicationPromiseEntryFilterWithAdditionalQueryParameters( "entryPointFilter", entryPoint,
                        identity, namespaceId, universalId, universalIdType, "ID_1", queryTimeoutSeconds ) );

        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    protected String getOutpatientMedicationPromiseEntryPointXpath( )
    {
        return "//medicationPromises";
    }

}
