

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadGenericObservationTest
    extends
        AbstractEndToEndTest
{
    private static final String CLIENT_NAME = "HMP";
    private static final String PATIENTIDENTITY_1 = "1";
    private static final String PATIENTIDENTITY_2 = "174";

    //private static final String ASSIGNING_FACILITY_1 = "247";
    //private static final String ASSIGNING_FACILITY_2 = "248";
    private static final String ASSIGNING_FACILITY_1 = "578";
    private static final String ASSIGNING_FACILITY_2 = "578";
    private static final String ASSIGNINGFACILITY_FAILURE_1 = "1";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String XPATH_GENERIC_OBSERVATION = "/clinicaldata:ClinicalData/patients/patient/genericObservations/genericObservation";
    private static final String XPATH_GENERIC_OBSERVATION_VALUE = "/clinicaldata:ClinicalData/patients/patient/genericObservations/genericObservation/observationValue";
    
    private static final String XPATH_ERRORSECTION = "//errorSection";
    private static final String XPATH_ERRORSECTION_WARNING_ERRORCODE = "/clinicaldata:ClinicalData/errorSection/warnings/warning/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_ERROR = "/clinicaldata:ClinicalData/errorSection/errors/error";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/clinicaldata:ClinicalData/errorSection/warnings/warning/displayMessage";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaGenericObservation( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient247 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_1, PATIENTIDENTITY_1 };
        String[] vistaPatient248 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_2, PATIENTIDENTITY_2 };
        String[][] patientIdentifiers = { vistaPatient247, vistaPatient248 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "GenericObservation" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "GenericObservation-Standardized" );

        // build other query parameters
        Map<String, String> otherQueryParametersMap = new HashMap<String, String>();
        otherQueryParametersMap.put( "domain", "PROBLEM" );

        // build filter
        String filterXml = createGenericObservationSinglePatientListDataFilter( entryPointFilterMap, resolvedPatients, "GenericObservation",
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, CLIENT_NAME, otherQueryParametersMap, null, null );

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_GENERIC_OBSERVATION_TEMPLATE_ID,
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, requestId, filterXml, resolvedPatients );
      

        List<Element> elementList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION );
        assertTrue( elementList.size() > 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaGenericObservation_StartEndDateParam( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient247 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_1, PATIENTIDENTITY_1 };
        String[] vistaPatient248 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_2, PATIENTIDENTITY_2 };
        String[][] patientIdentifiers = { vistaPatient247, vistaPatient248 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "GenericObservation" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "GenericObservation-Standardized" );

        // build other query parameters
        Map<String, String> otherQueryParametersMap = new HashMap<String, String>();
        otherQueryParametersMap.put( "domain", "PROBLEM" );

        // build filter
        String filterXml = createGenericObservationSinglePatientListDataFilter( entryPointFilterMap, resolvedPatients, "GenericObservation",
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, CLIENT_NAME, otherQueryParametersMap, "1990-01-01", "1999-12-31" );

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_GENERIC_OBSERVATION_TEMPLATE_ID,
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION );
        assertTrue( elementList.size() > 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaGenericObservation_MaxParam( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient247 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_1, PATIENTIDENTITY_1 };
        String[][] patientIdentifiers = { vistaPatient247 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "GenericObservation" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "GenericObservation-Standardized" );

        // build other query parameters
        Map<String, String> otherQueryParametersMap = new HashMap<String, String>();
        otherQueryParametersMap.put( "domain", "PROBLEM" );
        otherQueryParametersMap.put( "max", "100000" );

        // build filter
        String filterXml = createGenericObservationSinglePatientListDataFilter( entryPointFilterMap, resolvedPatients, "GenericObservation",
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, CLIENT_NAME, otherQueryParametersMap, null, null );

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_GENERIC_OBSERVATION_TEMPLATE_ID,
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION );
        assertTrue( elementList.size() > 0 );

        List<Element> valuesList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION_VALUE );
        assertTrue( elementList.size() > 0 );
       
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } ) 
    public void testVistaGenericObservation_UnnamedParam( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient247 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_1, PATIENTIDENTITY_1 };
        String[][] patientIdentifiers = { vistaPatient247 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "GenericObservation" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "GenericObservation-Standardized" );

        // build other query parameters
        Map<String, String> otherQueryParametersMap = new HashMap<String, String>();
        otherQueryParametersMap.put( "domain", "PROBLEM" );
        otherQueryParametersMap.put( "xyz", "abc" );

        // build filter
        String filterXml = createGenericObservationSinglePatientListDataFilter( entryPointFilterMap, resolvedPatients, "GenericObservation",
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, CLIENT_NAME, otherQueryParametersMap, null, null );

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.VISTA_GENERIC_OBSERVATION_TEMPLATE_ID,
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION );
        assertTrue( elementList.size() > 0 );

        List<Element> valuesList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION_VALUE );
        assertTrue( elementList.size() > 0 );
    }

    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaGenericObservation_SingleSiteFailure( )
        throws Exception
    {
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient247 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_1, PATIENTIDENTITY_1 };
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENTIDENTITY_2 };
        String[][] patientIdentifiers = { vistaPatient247, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "GenericObservation" );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, "GenericObservation-Standardized" );

        // build other query parameters
        Map<String, String> otherQueryParametersMap = new HashMap<String, String>();
        otherQueryParametersMap.put( "domain", "PROBLEM" );
        otherQueryParametersMap.put( "max", "100" );

        // build filter
        String filterXml = createGenericObservationSinglePatientListDataFilter( entryPointFilterMap, resolvedPatients, "GenericObservation",
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, CLIENT_NAME, otherQueryParametersMap, null, null );

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.VISTA_GENERIC_OBSERVATION_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.GENERIC_VISTA_LIST_DATA_FILTER, requestId );
       
        assertNotNull( dataDocument );

        List<Element> elementList = dataDocument.selectNodes( XPATH_GENERIC_OBSERVATION );
        assertTrue( elementList.size() > 0 );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() > 0 );

        // Check for single site failure error code
       //assertEquals( dataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNING_ERRORCODE ).getText(), "READ_REQUEST_DATA_SOURCE_FAILURE" );
    }


    protected String createGenericObservationSinglePatientListDataFilter( Map<String, String> entryPointFilterMap,
                    List<Map<String, String>> resolvedPatients, String entryPoint, String filterId, String clientName,
                    Map<String, String> otherQueryParametersMap, String startDate, String endDate )
    {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add( FilterBuilder.createFilterId( "filterId", filterId ) );
        element.add( FilterBuilder.createClientName( "clientName", clientName ) );
        element.add( FilterBuilder.createClientRequestInitiationTime( "clientRequestInitiationTime",
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) ) );
        element.add( FilterBuilder.createPatientWithResolvedIdentifiers( "patients", resolvedPatients ) );

        Element entryPointFilterElement = DocumentHelper.createElement( "entryPointFilter" );
        entryPointFilterElement.add( FilterBuilder.createDomainEntryPoint( "domainEntryPoint", entryPoint ) );

        if ( startDate != null && endDate != null )
        {
            entryPointFilterElement.add( FilterBuilder.createDateParameter( "startDate", startDate ) );
            entryPointFilterElement.add( FilterBuilder.createDateParameter( "endDate", endDate ) );
        }

        Iterator<String> keyIter = otherQueryParametersMap.keySet().iterator();
        Element otherQueryParametersElement = DocumentHelper.createElement( "otherQueryParameters" );
        while ( keyIter.hasNext() )
        {
            String key = keyIter.next();
            Element additionalParameterElement = DocumentHelper.createElement( "additionalParameter" );
            additionalParameterElement.addAttribute( "name", key );
            additionalParameterElement.addAttribute( "type", "text" );
            Element valueElement = DocumentHelper.createElement( "value" );
            valueElement.setText( otherQueryParametersMap.get( key ) );
            additionalParameterElement.add( valueElement );
            otherQueryParametersElement.add( additionalParameterElement );
        }

        entryPointFilterElement.add( otherQueryParametersElement );
        entryPointFilterElement.addAttribute( "queryName", "queryName" );

        element.add( entryPointFilterElement );
        element.addAttribute( "vhimVersion", "Vhim_4_00" );
        return element.asXML();
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, String filterXml,
                    List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = dataDocument.selectNodes( XPATH_PATIENT );
        assertTrue( domainElements.size() > 0 );

        // Assert that the resolved identifier values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = dataDocument.selectNodes( CDS_XPATH_IDENTIFIERS );
        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String resultsPatientIdentity = resultsResolvedIdentifiers.selectSingleNode( XPATH_PATIENT_IDENTITY_ELEMENT_NAME ).getText();

            Map<String, String> patientIdentityMap = null;
            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
            {
                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
                if ( mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
                {
                    patientIdentityMap = resolvedPatientMap;
                    break;
                }
            }

            assertNotNull( patientIdentityMap );
            String mapPatientIdentity = patientIdentityMap.get( FilterBuilder.IDENTITY );
            assertNotNull( mapPatientIdentity );
            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
        }

        return dataDocument;
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }
}
