

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadAppointmentsTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_VISTA = "100600";
    private static final String PATIENT_IDENTITY_VISTA_FAILING1 = "999999";
    private static final String PATIENT_IDENTITY_VISTA_FAILING2 = "patient_identity_1";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String ASSIGNINGFACILITY_FAILURE_1 = "503";
    private static final String ASSIGNINGFACILITY_FAILURE_2 = "504";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";

    private static final String XPATH_APPOINTMENTS = "/appointmentsdata:AppointmentsData/patients/patient/appointments/appointment";
    private static final String XPATH_ERRORSECTION = "//errorSection";
    private static final String XPATH_ERRORSECTION_WARNING = "/appointmentsdata:AppointmentsData/errorSection/warnings/warning";
    private static final String XPATH_ERRORSECTION_WARNING_ERRORCODE = "/appointmentsdata:AppointmentsData/errorSection/warnings/warning/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_ERROR = "/appointmentsdata:AppointmentsData/errorSection/errors/error";
    private static final String XPATH_ERRORSECTION_ERROR_ERRORCODE = "/appointmentsdata:AppointmentsData/errorSection/errors/error/errorCode";
    private static final String XPATH_ERRORSECTION_FATALERROR = "/appointmentsdata:AppointmentsData/errorSection/fatalErrors/fatalError";
    private static final String XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "/appointmentsdata:AppointmentsData/errorSection/fatalErrors/fatalError/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/appointmentsdata:AppointmentsData/errorSection/warnings/warning/displayMessage";
    private static final String XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "/appointmentsdata:AppointmentsData/errorSection/fatalErrors/fatalError/displayMessage";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadVrmTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsNoDates_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsWithDates_SingleSite( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 10 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsWithDates_MultiSite( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient578 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 20 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "timeouttest" } )
    /* this test is failing only on continuous, should be fixed*/
    public void testVistaAppointmentsWithDates_MultiSiteTimeout( )
        throws Exception
    {
        String TIMOUT_SECONDS = "1";

        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient578 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_TIMEOUT_SECONDS, TIMOUT_SECONDS );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId );

        List<Element> elementList = dataDocument.selectNodes( XPATH_ERRORSECTION_ERROR_ERRORCODE );
        if ( elementList != null && elementList.size() > 0 )
            assertTrue( elementList.get( 0 ).getText().equals( TIMOUT_ERROR_CODE ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsStartDateNoEndDate_SingleSite( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = null;
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 10 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsEndDateNoStartDate_SingleSite( )
        throws Exception
    {
        String startDate = null;
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsNoData_SingleSite( )
        throws Exception
    {
        /*
         * Calling the SP with patient 100600 without providing startDate and endDate parameters will
         * return no data, as there is no data for this patient "90-current_date+120" days.
         */

        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_APPOINTMENTS );
        assertTrue( elementList.size() == 0 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaAppointmentsPartialReadOneFailure_MultiSite( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING1 };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 1 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_ERRORSECTION_WARNING_ERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_DATA_SOURCE_FAILURE ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "brokentest" } )
    public void testVistaAppointments_AllSitesFailure( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING1 };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING2 };
        String[][] patientIdentifiers = { vistaPatient503, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        // make sure we reported error message as a fatalError
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_ERRORSECTION_FATALERROR );
        Assert.assertTrue( warningNodes.size() == 1 );

        // make sure we reported one READ_REQUEST_ALL_DATA_SOURCES_FAILED successfully as a fatalError        
        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_ERRORSECTION_FATALERROR_ERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED ) );

        Node fatalErrorDisplayMsgtNode = dataDocument.selectSingleNode( XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG );
        Assert.assertTrue( fatalErrorDisplayMsgtNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED_MSG ) );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, String filterXml,
                    List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        Assert.assertXmlValidation( dataDocument.asXML(), templateId, "Appointmentsdata" );

        // Check for domain entry point elements
        List<Element> domainElements = dataDocument.selectNodes( XPATH_PATIENT );
        assertTrue( domainElements.size() > 0 );

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = dataDocument.selectNodes( CDS_XPATH_IDENTIFIERS );
        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String resultsAssigningAuthority = resultsResolvedIdentifiers.selectSingleNode( XPATH_ASSIGNING_AUTHORITY_ELEMENT_NAME ).getText();
            String resultsAssigningFacility = resultsResolvedIdentifiers.selectSingleNode( XPATH_ASSIGNING_FACILITY_ELEMENT_NAME ).getText();
            String resultsPatientIdentity = resultsResolvedIdentifiers.selectSingleNode( XPATH_PATIENT_IDENTITY_ELEMENT_NAME ).getText();

            Map<String, String> assigningAuthorityFacilityAndPatientIdentityMap = null;
            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
            {
                String mapAssigningAuthority = resolvedPatientMap.get( FilterBuilder.ASSIGNING_AUTHORITY_KEY );
                String mapAssigningFacility = resolvedPatientMap.get( FilterBuilder.ASSIGNING_FACILITY );
                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
                if ( mapAssigningAuthority != null && mapAssigningAuthority.equalsIgnoreCase( resultsAssigningAuthority )
                                && mapAssigningFacility != null && mapAssigningFacility.equalsIgnoreCase( resultsAssigningFacility )
                                && mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
                {
                    assigningAuthorityFacilityAndPatientIdentityMap = resolvedPatientMap;
                    break;
                }
            }

            assertNotNull( assigningAuthorityFacilityAndPatientIdentityMap );
            String mapPatientIdentity = assigningAuthorityFacilityAndPatientIdentityMap.get( FilterBuilder.IDENTITY );
            assertNotNull( mapPatientIdentity );
            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
        }

        return dataDocument;
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }
}
