

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.integration.AbstractEndToEndOutpatientPharmacyTest;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.OutpatientMedicationPromiseBuilder;
import gov.va.med.cds.testharness.vhim400.builders.OutpatientMedicationPromiseBuilderFactory;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/exceptionHandlingConfigContext.xml" } )
public class EndToEndOutpatientPharmacyTest
    extends
        AbstractEndToEndOutpatientPharmacyTest
{
    private static final String PATIENTIDENTITY_HDR = "testId5555";
    private static final String ASSIGNING_FACILITY_HDR = "200CH";
    private static final String ASSIGNING_AUTHORITY_HDR = "USDOD";

    protected static final String DOMAINENTRYPOINT_XPATH = "//outpatientMedicationPromises";
    protected static final String REQUEST_ID_XPATH = "/clinicaldata:ClinicalData/requestId";
    protected static final String PATIENT_ID_XPATH = "//outpatientMedicationPromises/patient/identifier/identity";
    protected static final String SIG_XPATH = "//outpatientMedicationPromises/sig";
    protected static final String RECORD_IDENTIFIER_XPATH = "//recordIdentifier/identity";

    protected static final String ERROR_SECTION_ERRORS_XPATH = "//clinicaldata:ClinicalData/errorSection/errors";
    protected static final String ERROR_SECTION_WARNINGS_XPATH = "//clinicaldata:ClinicalData/errorSection/warnings";
    protected static final String ERROR_SECTION_FATAL_ERRORS_XPATH = "//clinicaldata:ClinicalData/errorSection/fatalErrors";

    @Autowired
    protected JdbcTemplate hdrJdbcTemplate;


    @BeforeTestsOnce
    @Suite( groups = { "checkintest" } )
    public void beforeAbstractRequestValidationTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testOutpatientMedicationPromisesCreate( )
        throws Exception
    {
        // Clean up any old test data
        doDelete( PATIENTIDENTITY_HDR );

        String requestId = new UniqueIdentifier().toString();
        Document createRequestDoc = createWriteRequestXml();
        String createRequestXml = createRequestDoc.asXML();

        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, createRequestXml, requestId );
        assertNotNull( clinicalDataDocument );

        // Verify requestId
        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );

        // Perform read
        String patientIdentifier = createRequestDoc.selectSingleNode( PATIENT_ID_XPATH ).getText();
        Document readClinicalDataDocument = readClinicalData( patientIdentifier );

        // Verify patientIdentifier
        String readPatientIdentifier = readClinicalDataDocument.selectSingleNode( PATIENT_ID_XPATH ).getText();
        assertTrue( patientIdentifier.equals( readPatientIdentifier ) );

        // Verify recordIdentifier
        String recordIdentifier = createRequestDoc.selectSingleNode( RECORD_IDENTIFIER_XPATH ).getText();
        Node readRecordIdentifierElement = readClinicalDataDocument.selectSingleNode( "//recordIdentifier[identity='" + recordIdentifier + "']" );
        assertNotNull( readRecordIdentifierElement );
        String readIdentity = readRecordIdentifierElement.selectSingleNode( "identity" ).getText();
        assertTrue( recordIdentifier.equals( readIdentity ) );

        // Clean up
        doDelete( PATIENTIDENTITY_HDR );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testOutpatientMedicationPromisesCreatePartial( )
        throws Exception
    {
        // Clean up any old test data
        doDelete( PATIENTIDENTITY_HDR );

        String requestId = new UniqueIdentifier().toString();
        Document createRequestDoc = createWriteRequestXml();

        // Detach optional child associations
        List<Element> refillDispenseList = createRequestDoc.selectNodes( "//refillDispenses" );
        for ( Element refillDispense : refillDispenseList )
        {
            refillDispense.detach();
        }

        String createRequestXml = createRequestDoc.asXML();
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, createRequestXml, requestId );
        assertNotNull( clinicalDataDocument );

        // Verify requestId
        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );

        // Perform read
        String patientIdentifier = createRequestDoc.selectSingleNode( PATIENT_ID_XPATH ).getText();
        Document readClinicalDataDocument = readClinicalData( patientIdentifier );

        // Verify patientIdentifier
        String readPatientIdentifier = readClinicalDataDocument.selectSingleNode( PATIENT_ID_XPATH ).getText();
        assertTrue( patientIdentifier.equals( readPatientIdentifier ) );

        // Verify recordIdentifier
        String recordIdentifier = createRequestDoc.selectSingleNode( RECORD_IDENTIFIER_XPATH ).getText();
        Node readRecordIdentifierElement = readClinicalDataDocument.selectSingleNode( "//recordIdentifier[identity='" + recordIdentifier + "']" );
        assertNotNull( readRecordIdentifierElement );
        String readIdentity = readRecordIdentifierElement.selectSingleNode( "identity" ).getText();
        assertTrue( recordIdentifier.equals( readIdentity ) );

        // Clean up
        doDelete( PATIENTIDENTITY_HDR );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testOutpatientMedicationPromisesCreateInvalid( )
        throws Exception
    {
        // Create journal entry with no patient identity
        String requestId = new UniqueIdentifier().toString();
        Document createRequestDoc = createWriteRequestXml();
        createRequestDoc.selectSingleNode( PATIENT_ID_XPATH ).detach();
        String createRequestXml = createRequestDoc.asXML();

        Document clinicalDataDocument = requestProcessor.createClinicalData( createRequestXml, TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID,
                        requestId );
        assertNotNull( clinicalDataDocument );

        // Check for an empty error section
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        Element errorSection = errorSections.get( 0 );
        assertTrue( errorSection.content().size() == 1 );

        List<Element> fatalErrors = clinicalDataDocument.selectNodes( ERROR_SECTION_FATAL_ERRORS_XPATH );
        assertTrue( fatalErrors.size() == 1 );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testOutpatientMedicationPromisesCreateWithEmptySig( )
        throws Exception
    {
        // Clean up any old test data
        doDelete( PATIENTIDENTITY_HDR );

        String requestId = new UniqueIdentifier().toString();
        Document createRequestDoc = createWriteRequestXml();
        
        createRequestDoc.selectSingleNode( SIG_XPATH ).detach();
        createRequestDoc.selectSingleNode( SIG_XPATH ).setText( "" );
        
        String createRequestXml = createRequestDoc.asXML();
        //String createRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>PharmacyCreateOrUpdate40060</templateId><patient><outpatientMedicationPromises><recordIdentifier><identity>ID_137901859109010000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109010000</universalId><universalIdType>universalIdType</universalIdType></recordIdentifier><pdtsPrescriptionId>PdtsPrescriptionId</pdtsPrescriptionId><prescriptionId>PrescriptionId</prescriptionId><pharmacyPatientType>PharmacyPatientType</pharmacyPatientType><specialDrugTracking><totalDailyDosage><value>1.0</value><unit><code>test_code_2002</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></totalDailyDosage><wbcObservation><count><value>10.0</value><unit><code>test_code_2005</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></count><testDate><literal>20130912144311-0600</literal></testDate></wbcObservation></specialDrugTracking><dataEnterer><comment>DataEnterer</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_1</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></dataEnterer><pharmacyRequest><cosigner><comment>Cosigner</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_13002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></cosigner><orderedMedication><cmopDrugCode><code>test_code_2001</code><displayText>OrderedMedication CmopDrugCdDisplayTextLite</displayText><codingSystem>OrderedMedication CmopDrugCdCodingSystemLite</codingSystem></cmopDrugCode><medicationCode><code>test_code_2003</code><displayText> Med Alt CodeDisplayTextLite</displayText><codingSystem> Med Alt CodeCodingSystemLite</codingSystem><alternateCode> Med Alt Codetest_altcode_3004</alternateCode><alternateDisplayText> Med Alt CodeAltDisplayTextLite</alternateDisplayText><alternateCodingSystem> Med Alt CodeAltCodingSystem</alternateCodingSystem></medicationCode><otcCode><code>test_code_2002</code><displayText>OrderedMedication NDFCdDisplayTextLite</displayText><codingSystem>OrderedMedication NDFCdCodingSystemLite</codingSystem></otcCode><tradeName><code>test_code_2005</code><displayText>OrderedMedication TradeNmDisplayTextLite</displayText><codingSystem>OrderedMedication TradeNmCodingSystemLite</codingSystem></tradeName></orderedMedication><genericRequestIdentifier><identity>ID_1379018591092</identity><namespaceId>992</namespaceId><universalId>UID_1379018591092</universalId><universalIdType>universalIdType</universalIdType></genericRequestIdentifier><orderLocationIdentifier><pointOfCare>PointOfCare</pointOfCare><room>Room</room><bed>Bed</bed><facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId><facilityUniversalId>FacilityUniversalId</facilityUniversalId><facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType><personLocationType>PersonLocationType</personLocationType><locationDescription>LocationDescription</locationDescription></orderLocationIdentifier><orderedItem><itemCode><code>test_code_2002</code><displayText>OrderedItem ItemDisplayTextLite</displayText><codingSystem>OrderedItem ItemCodingSystemLite</codingSystem></itemCode><dosageFormCode><code>test_code_2004</code><displayText>DosageFormDisplayTextLite</displayText><codingSystem>DosageFormCodingSystemLite</codingSystem></dosageFormCode></orderedItem><orderingInstitutionIdentifier><identity>OrganizationId</identity><name>OrganizationName</name><assigningAuthority>AssigningAuthNamespaceId</assigningAuthority></orderingInstitutionIdentifier><orderDate><literal>20130912144311-0600</literal></orderDate><status>Status</status><statusModifier><code>test_code_2003</code><displayText>StatusModifierDisplayTextLite</displayText><codingSystem>StatusModifierCodingSystemLite</codingSystem></statusModifier></pharmacyRequest><patient><identifier><identity>testId5555</identity><assigningFacility>200CH</assigningFacility><assigningAuthority>USDOD</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><expirationDate><literal>20130912144311-0600</literal></expirationDate><lastDispenseDate><literal>20130912144311-0600</literal></lastDispenseDate><numberOfRefillsAuthorized>2</numberOfRefillsAuthorized><patientInstructions>PatientInstructions-0</patientInstructions><patientInstructions>PatientInstructions-1</patientInstructions><otherPatientInstructions>OtherPatientInstructions-0</otherPatientInstructions><otherPatientInstructions>OtherPatientInstructions-1</otherPatientInstructions><expandedPatientInstructions>ExpandedPatientInstructions-0</expandedPatientInstructions><expandedPatientInstructions>ExpandedPatientInstructions-1</expandedPatientInstructions><pharmacyInstructions>PharmacyInstructions-0</pharmacyInstructions><pharmacyInstructions>PharmacyInstructions-1</pharmacyInstructions><sig></sig><digitalSignatureIndicator><code>test_code_2004</code><displayText>DigitalSignatureIndicatorDisplayTextLite</displayText><codingSystem>DigitalSignatureIndicatorCodingSystemLite</codingSystem></digitalSignatureIndicator><copayTransactionType><code>test_code_2003</code><displayText>CopayTransactionTypeDisplayTextLite</displayText><codingSystem>CopayTransactionTypeCodingSystemLite</codingSystem></copayTransactionType><transitionalRxBenefit><code>test_code_2002</code><displayText>TransitionalRxBenefitDisplayTextLite</displayText><codingSystem>TransitionalRxBenefitCodingSystemLite</codingSystem></transitionalRxBenefit><treatmentFactor><factor><code>test_code_2004</code><displayText>FactorDisplayTextLite</displayText><codingSystem>FactorCodingSystemLite</codingSystem></factor><factorValue><code>test_code_2003</code><displayText>FactorValueDisplayTextLite</displayText><codingSystem>FactorValueCodingSystemLite</codingSystem></factorValue></treatmentFactor><originalDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2002</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERD_7001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109410000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109410000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2005</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2002</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2004</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2003</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>OriginalnewLotId</lotId><ndc><code>test_code_2003</code><displayText>OriginalNdcDisplayTextLite</displayText><codingSystem>OriginalNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2004</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></originalDispense><refillDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2001</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901850109010000</identity><namespaceId>992</namespaceId><universalId>UID_137901850109010000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2002</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2004</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2005</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2002</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>RefillnewLotId</lotId><ndc><code>test_code_2005</code><displayText>RefillNdcDisplayTextLite</displayText><codingSystem>RefillNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2005</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></refillDispense><refillDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109710000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109710000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2001</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2005</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2003</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2002</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>RefillnewLotId</lotId><ndc><code>test_code_2004</code><displayText>RefillNdcDisplayTextLite</displayText><codingSystem>RefillNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2002</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></refillDispense><partialDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERD_7001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109910000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109910000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2002</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2002</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2005</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2005</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2005</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>PartialnewLotId</lotId><ndc><code>test_code_2004</code><displayText>PartialNdcDisplayTextLite</displayText><codingSystem>PartialNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2005</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></partialDispense><partialDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859110010000</identity><namespaceId>992</namespaceId><universalId>UID_137901859110010000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2003</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2001</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2003</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2002</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2003</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>PartialnewLotId</lotId><ndc><code>test_code_2001</code><displayText>PartialNdcDisplayTextLite</displayText><codingSystem>PartialNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2003</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></partialDispense><cancel><cancelDate><literal>20130912144311-0600</literal></cancelDate><comments>CancelAct_Comment-0</comments><comments>CancelAct_Comment-1</comments></cancel><medicationInstructions><conjunction><code>test_code_2001</code><displayText>ConjunctionDisplayTextLite</displayText><codingSystem>ConjunctionCodingSystemLite</codingSystem></conjunction><dispenseUnitsPerDose>15.0</dispenseUnitsPerDose><dosageOrdered>DosageOrdered</dosageOrdered><noun><code>test_code_2005</code><displayText>NounDisplayTextLite</displayText><codingSystem>NounCodingSystemLite</codingSystem></noun><route><code>test_code_2001</code><displayText>RouteDisplayTextLite</displayText><codingSystem>RouteCodingSystemLite</codingSystem></route><schedule><code>test_code_2002</code><displayText>ScheduleDisplayTextLite</displayText><codingSystem>ScheduleCodingSystemLite</codingSystem></schedule><verb><code>test_code_2003</code><displayText>VerbDisplayTextLite</displayText><codingSystem>VerbCodingSystemLite</codingSystem></verb><giveUnits><code>test_code_2002</code><displayText>VistaGiveUnitsDisplayTextLite</displayText><codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem></giveUnits><intendedDuration>IntendedDuration</intendedDuration></medicationInstructions><medicationInstructions><conjunction><code>test_code_2003</code><displayText>ConjunctionDisplayTextLite</displayText><codingSystem>ConjunctionCodingSystemLite</codingSystem></conjunction><dispenseUnitsPerDose>15.0</dispenseUnitsPerDose><dosageOrdered>DosageOrdered</dosageOrdered><noun><code>test_code_2001</code><displayText>NounDisplayTextLite</displayText><codingSystem>NounCodingSystemLite</codingSystem></noun><route><code>test_code_2001</code><displayText>RouteDisplayTextLite</displayText><codingSystem>RouteCodingSystemLite</codingSystem></route><schedule><code>test_code_2003</code><displayText>ScheduleDisplayTextLite</displayText><codingSystem>ScheduleCodingSystemLite</codingSystem></schedule><verb><code>test_code_2005</code><displayText>VerbDisplayTextLite</displayText><codingSystem>VerbCodingSystemLite</codingSystem></verb><giveUnits><code>test_code_2002</code><displayText>VistaGiveUnitsDisplayTextLite</displayText><codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem></giveUnits><intendedDuration>IntendedDuration</intendedDuration></medicationInstructions><finisher><comment>Finisher Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_FINISHERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></finisher><activityLog><activityDate><literal>20130912144311-0600</literal></activityDate><reason><code>test_code_2005</code><displayText>ReasonDisplayTextLite</displayText><codingSystem>ReasonCodingSystemLite</codingSystem></reason><initiator><comment>Initiator Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_INITIATOR_17002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></initiator><comment>ActivityLog Comment</comment></activityLog><activityLog><activityDate><literal>20130912144311-0600</literal></activityDate><reason><code>test_code_2002</code><displayText>ReasonDisplayTextLite</displayText><codingSystem>ReasonCodingSystemLite</codingSystem></reason><initiator><comment>Initiator Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_INITIATOR_17003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></initiator><comment>ActivityLog Comment</comment></activityLog><recordSource><namespaceId>992</namespaceId><universalId>1379018591103100000</universalId><universalIdType>universalIdType</universalIdType></recordSource><recordVersion>10000</recordVersion><recordUpdateTime><literal>20130912144311-0600</literal></recordUpdateTime></outpatientMedicationPromises></patient></clinicaldata:ClinicalData>";
        
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, createRequestXml, requestId );
        assertNotNull( clinicalDataDocument );

        // Verify requestId
        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );

        // Perform read
        String patientIdentifier = createRequestDoc.selectSingleNode( PATIENT_ID_XPATH ).getText();
        Document readClinicalDataDocument = readClinicalData( patientIdentifier );

        // Verify patientIdentifier
        String readPatientIdentifier = readClinicalDataDocument.selectSingleNode( PATIENT_ID_XPATH ).getText();
        assertTrue( patientIdentifier.equals( readPatientIdentifier ) );

        // Verify recordIdentifier
        String recordIdentifier = createRequestDoc.selectSingleNode( RECORD_IDENTIFIER_XPATH ).getText();
        Node readRecordIdentifierElement = readClinicalDataDocument.selectSingleNode( "//recordIdentifier[identity='" + recordIdentifier + "']" );
        assertNotNull( readRecordIdentifierElement );
        String readIdentity = readRecordIdentifierElement.selectSingleNode( "identity" ).getText();
        assertTrue( recordIdentifier.equals( readIdentity ) );

        // Clean up
        doDelete( PATIENTIDENTITY_HDR );
    }    


    @Test
    @Suite( groups = { "checkintest" } )
    public void testOutpatientMedicationPromisesCreateWithPartialEmptySig( )
        throws Exception
    {
        // Clean up any old test data
        doDelete( PATIENTIDENTITY_HDR );

        String requestId = new UniqueIdentifier().toString();
        Document createRequestDoc = createWriteRequestXml();
        
        createRequestDoc.selectSingleNode( SIG_XPATH ).setText( "" );
        
        String createRequestXml = createRequestDoc.asXML();
        //String createRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>PharmacyCreateOrUpdate40060</templateId><patient><outpatientMedicationPromises><recordIdentifier><identity>ID_137901859109010000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109010000</universalId><universalIdType>universalIdType</universalIdType></recordIdentifier><pdtsPrescriptionId>PdtsPrescriptionId</pdtsPrescriptionId><prescriptionId>PrescriptionId</prescriptionId><pharmacyPatientType>PharmacyPatientType</pharmacyPatientType><specialDrugTracking><totalDailyDosage><value>1.0</value><unit><code>test_code_2002</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></totalDailyDosage><wbcObservation><count><value>10.0</value><unit><code>test_code_2005</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></count><testDate><literal>20130912144311-0600</literal></testDate></wbcObservation></specialDrugTracking><dataEnterer><comment>DataEnterer</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_1</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></dataEnterer><pharmacyRequest><cosigner><comment>Cosigner</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_13002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></cosigner><orderedMedication><cmopDrugCode><code>test_code_2001</code><displayText>OrderedMedication CmopDrugCdDisplayTextLite</displayText><codingSystem>OrderedMedication CmopDrugCdCodingSystemLite</codingSystem></cmopDrugCode><medicationCode><code>test_code_2003</code><displayText> Med Alt CodeDisplayTextLite</displayText><codingSystem> Med Alt CodeCodingSystemLite</codingSystem><alternateCode> Med Alt Codetest_altcode_3004</alternateCode><alternateDisplayText> Med Alt CodeAltDisplayTextLite</alternateDisplayText><alternateCodingSystem> Med Alt CodeAltCodingSystem</alternateCodingSystem></medicationCode><otcCode><code>test_code_2002</code><displayText>OrderedMedication NDFCdDisplayTextLite</displayText><codingSystem>OrderedMedication NDFCdCodingSystemLite</codingSystem></otcCode><tradeName><code>test_code_2005</code><displayText>OrderedMedication TradeNmDisplayTextLite</displayText><codingSystem>OrderedMedication TradeNmCodingSystemLite</codingSystem></tradeName></orderedMedication><genericRequestIdentifier><identity>ID_1379018591092</identity><namespaceId>992</namespaceId><universalId>UID_1379018591092</universalId><universalIdType>universalIdType</universalIdType></genericRequestIdentifier><orderLocationIdentifier><pointOfCare>PointOfCare</pointOfCare><room>Room</room><bed>Bed</bed><facilityNamespaceId>FacilityNamespaceId</facilityNamespaceId><facilityUniversalId>FacilityUniversalId</facilityUniversalId><facilityUniversalIdType>FacilityUniversalIdType</facilityUniversalIdType><personLocationType>PersonLocationType</personLocationType><locationDescription>LocationDescription</locationDescription></orderLocationIdentifier><orderedItem><itemCode><code>test_code_2002</code><displayText>OrderedItem ItemDisplayTextLite</displayText><codingSystem>OrderedItem ItemCodingSystemLite</codingSystem></itemCode><dosageFormCode><code>test_code_2004</code><displayText>DosageFormDisplayTextLite</displayText><codingSystem>DosageFormCodingSystemLite</codingSystem></dosageFormCode></orderedItem><orderingInstitutionIdentifier><identity>OrganizationId</identity><name>OrganizationName</name><assigningAuthority>AssigningAuthNamespaceId</assigningAuthority></orderingInstitutionIdentifier><orderDate><literal>20130912144311-0600</literal></orderDate><status>Status</status><statusModifier><code>test_code_2003</code><displayText>StatusModifierDisplayTextLite</displayText><codingSystem>StatusModifierCodingSystemLite</codingSystem></statusModifier></pharmacyRequest><patient><identifier><identity>testId5555</identity><assigningFacility>200CH</assigningFacility><assigningAuthority>USDOD</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><expirationDate><literal>20130912144311-0600</literal></expirationDate><lastDispenseDate><literal>20130912144311-0600</literal></lastDispenseDate><numberOfRefillsAuthorized>2</numberOfRefillsAuthorized><patientInstructions>PatientInstructions-0</patientInstructions><patientInstructions>PatientInstructions-1</patientInstructions><otherPatientInstructions>OtherPatientInstructions-0</otherPatientInstructions><otherPatientInstructions>OtherPatientInstructions-1</otherPatientInstructions><expandedPatientInstructions>ExpandedPatientInstructions-0</expandedPatientInstructions><expandedPatientInstructions>ExpandedPatientInstructions-1</expandedPatientInstructions><pharmacyInstructions>PharmacyInstructions-0</pharmacyInstructions><pharmacyInstructions>PharmacyInstructions-1</pharmacyInstructions><sig></sig><digitalSignatureIndicator><code>test_code_2004</code><displayText>DigitalSignatureIndicatorDisplayTextLite</displayText><codingSystem>DigitalSignatureIndicatorCodingSystemLite</codingSystem></digitalSignatureIndicator><copayTransactionType><code>test_code_2003</code><displayText>CopayTransactionTypeDisplayTextLite</displayText><codingSystem>CopayTransactionTypeCodingSystemLite</codingSystem></copayTransactionType><transitionalRxBenefit><code>test_code_2002</code><displayText>TransitionalRxBenefitDisplayTextLite</displayText><codingSystem>TransitionalRxBenefitCodingSystemLite</codingSystem></transitionalRxBenefit><treatmentFactor><factor><code>test_code_2004</code><displayText>FactorDisplayTextLite</displayText><codingSystem>FactorCodingSystemLite</codingSystem></factor><factorValue><code>test_code_2003</code><displayText>FactorValueDisplayTextLite</displayText><codingSystem>FactorValueCodingSystemLite</codingSystem></factorValue></treatmentFactor><originalDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2002</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERD_7001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109410000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109410000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2005</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2002</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2004</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2003</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>OriginalnewLotId</lotId><ndc><code>test_code_2003</code><displayText>OriginalNdcDisplayTextLite</displayText><codingSystem>OriginalNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2004</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></originalDispense><refillDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2001</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901850109010000</identity><namespaceId>992</namespaceId><universalId>UID_137901850109010000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2002</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2004</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2005</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2002</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>RefillnewLotId</lotId><ndc><code>test_code_2005</code><displayText>RefillNdcDisplayTextLite</displayText><codingSystem>RefillNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2005</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></refillDispense><refillDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109710000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109710000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2004</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2001</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2005</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2003</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2002</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>RefillnewLotId</lotId><ndc><code>test_code_2004</code><displayText>RefillNdcDisplayTextLite</displayText><codingSystem>RefillNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2002</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></refillDispense><partialDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERD_7001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859109910000</identity><namespaceId>992</namespaceId><universalId>UID_137901859109910000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2002</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2002</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2005</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2005</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2005</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>PartialnewLotId</lotId><ndc><code>test_code_2004</code><displayText>PartialNdcDisplayTextLite</displayText><codingSystem>PartialNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6001</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2005</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></partialDispense><partialDispense><comments>Comments-0</comments><comments>Comments-1</comments><dispenseDate><literal>20130912144311-0600</literal></dispenseDate><fillDate><literal>20130912144311-0600</literal></fillDate><quantityDispensed><value>1.0</value><unit><code>test_code_2004</code><displayText>UnitDisplayTextLite</displayText><codingSystem>UnitCodingSystemLite</codingSystem></unit></quantityDispensed><currentProvider><identifier><identity>test_PROVIDERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></currentProvider><currentProviderComments>ProviderComments-0</currentProviderComments><currentProviderComments>ProviderComments-1</currentProviderComments><loginDate><literal>20130912144311-0600</literal></loginDate><daysSupply>5</daysSupply><identifier><identity>ID_137901859110010000</identity><namespaceId>992</namespaceId><universalId>UID_137901859110010000</universalId><universalIdType>universalIdType</universalIdType></identifier><levelOfUnderstanding><code>test_code_2003</code><displayText>LevelOfUnderstandingDisplayTextLite</displayText><codingSystem>LevelOfUnderstandingCodingSystemLite</codingSystem></levelOfUnderstanding><mailWindow>MailWindow</mailWindow><releaseDate><literal>20130912144311-0600</literal></releaseDate><wasPatientCounseled><code>test_code_2001</code><displayText>WasPatientCounseledDisplayTextLite</displayText><codingSystem>WasPatientCounseledCodingSystemLite</codingSystem></wasPatientCounseled><division><divisionId><code>test_code_2003</code><displayText>DivisionIdDisplayTextLite</displayText><codingSystem>DivisionIdCodingSystemLite</codingSystem></divisionId><ncpdpId><code>test_code_2002</code><displayText>NcpdpIdDisplayTextLite</displayText><codingSystem>NcpdpIdCodingSystemLite</codingSystem></ncpdpId></division><dispensedDrug><drugUnitPrice><currency><code>test_code_2003</code><displayText>CurrencyDisplayTextLite</displayText><codingSystem>CurrencyCodingSystemLite</codingSystem></currency><value>0.0</value></drugUnitPrice><expirationDate><literal>20130912144311-0600</literal></expirationDate><lotId>PartialnewLotId</lotId><ndc><code>test_code_2001</code><displayText>PartialNdcDisplayTextLite</displayText><codingSystem>PartialNdcCodingSystemLite</codingSystem></ndc></dispensedDrug><pharmacist><comment>Pharmacist Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_IDS_6003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></pharmacist><cmopEventStatus><code>test_code_2003</code><displayText>CmopEventStatusDisplayTextLite</displayText><codingSystem>CmopEventStatusCodingSystemLite</codingSystem></cmopEventStatus><numberOfRefillsRemaining>13</numberOfRefillsRemaining></partialDispense><cancel><cancelDate><literal>20130912144311-0600</literal></cancelDate><comments>CancelAct_Comment-0</comments><comments>CancelAct_Comment-1</comments></cancel><medicationInstructions><conjunction><code>test_code_2001</code><displayText>ConjunctionDisplayTextLite</displayText><codingSystem>ConjunctionCodingSystemLite</codingSystem></conjunction><dispenseUnitsPerDose>15.0</dispenseUnitsPerDose><dosageOrdered>DosageOrdered</dosageOrdered><noun><code>test_code_2005</code><displayText>NounDisplayTextLite</displayText><codingSystem>NounCodingSystemLite</codingSystem></noun><route><code>test_code_2001</code><displayText>RouteDisplayTextLite</displayText><codingSystem>RouteCodingSystemLite</codingSystem></route><schedule><code>test_code_2002</code><displayText>ScheduleDisplayTextLite</displayText><codingSystem>ScheduleCodingSystemLite</codingSystem></schedule><verb><code>test_code_2003</code><displayText>VerbDisplayTextLite</displayText><codingSystem>VerbCodingSystemLite</codingSystem></verb><giveUnits><code>test_code_2002</code><displayText>VistaGiveUnitsDisplayTextLite</displayText><codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem></giveUnits><intendedDuration>IntendedDuration</intendedDuration></medicationInstructions><medicationInstructions><conjunction><code>test_code_2003</code><displayText>ConjunctionDisplayTextLite</displayText><codingSystem>ConjunctionCodingSystemLite</codingSystem></conjunction><dispenseUnitsPerDose>15.0</dispenseUnitsPerDose><dosageOrdered>DosageOrdered</dosageOrdered><noun><code>test_code_2001</code><displayText>NounDisplayTextLite</displayText><codingSystem>NounCodingSystemLite</codingSystem></noun><route><code>test_code_2001</code><displayText>RouteDisplayTextLite</displayText><codingSystem>RouteCodingSystemLite</codingSystem></route><schedule><code>test_code_2003</code><displayText>ScheduleDisplayTextLite</displayText><codingSystem>ScheduleCodingSystemLite</codingSystem></schedule><verb><code>test_code_2005</code><displayText>VerbDisplayTextLite</displayText><codingSystem>VerbCodingSystemLite</codingSystem></verb><giveUnits><code>test_code_2002</code><displayText>VistaGiveUnitsDisplayTextLite</displayText><codingSystem>VistaGiveUnitsCodingSystemLite</codingSystem></giveUnits><intendedDuration>IntendedDuration</intendedDuration></medicationInstructions><finisher><comment>Finisher Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_FINISHERID_7003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></finisher><activityLog><activityDate><literal>20130912144311-0600</literal></activityDate><reason><code>test_code_2005</code><displayText>ReasonDisplayTextLite</displayText><codingSystem>ReasonCodingSystemLite</codingSystem></reason><initiator><comment>Initiator Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_INITIATOR_17002</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></initiator><comment>ActivityLog Comment</comment></activityLog><activityLog><activityDate><literal>20130912144311-0600</literal></activityDate><reason><code>test_code_2002</code><displayText>ReasonDisplayTextLite</displayText><codingSystem>ReasonCodingSystemLite</codingSystem></reason><initiator><comment>Initiator Comment</comment><time><literal>20130912144311-0600</literal></time><practitioner><identifier><identity>test_INITIATOR_17003</identity><assigningFacility>992</assigningFacility><assigningAuthority>USVHA</assigningAuthority></identifier><idSourceTable>IdSourceTable</idSourceTable><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></practitioner></initiator><comment>ActivityLog Comment</comment></activityLog><recordSource><namespaceId>992</namespaceId><universalId>1379018591103100000</universalId><universalIdType>universalIdType</universalIdType></recordSource><recordVersion>10000</recordVersion><recordUpdateTime><literal>20130912144311-0600</literal></recordUpdateTime></outpatientMedicationPromises></patient></clinicaldata:ClinicalData>";
        
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, createRequestXml, requestId );
        assertNotNull( clinicalDataDocument );

        // Verify requestId
        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );

        // Perform read
        String patientIdentifier = createRequestDoc.selectSingleNode( PATIENT_ID_XPATH ).getText();
        Document readClinicalDataDocument = readClinicalData( patientIdentifier );

        // Verify patientIdentifier
        String readPatientIdentifier = readClinicalDataDocument.selectSingleNode( PATIENT_ID_XPATH ).getText();
        assertTrue( patientIdentifier.equals( readPatientIdentifier ) );

        // Verify recordIdentifier
        String recordIdentifier = createRequestDoc.selectSingleNode( RECORD_IDENTIFIER_XPATH ).getText();
        Node readRecordIdentifierElement = readClinicalDataDocument.selectSingleNode( "//recordIdentifier[identity='" + recordIdentifier + "']" );
        assertNotNull( readRecordIdentifierElement );
        String readIdentity = readRecordIdentifierElement.selectSingleNode( "identity" ).getText();
        assertTrue( recordIdentifier.equals( readIdentity ) );

        // Clean up
        doDelete( PATIENTIDENTITY_HDR );
    }    

    
    private Document createWriteRequestXml( )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, DomainEntryPoint.OutpatientMedicationPromise );

        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        OutpatientMedicationPromiseBuilderFactory factory = new OutpatientMedicationPromiseBuilderFactory();
        factory.setOutpatientMedicationPromiseBuilder( new OutpatientMedicationPromiseBuilder() );
        domainEntryPointsWrappersMap.put( "OutpatientMedicationPromise", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", PATIENTIDENTITY_HDR, ASSIGNING_FACILITY_HDR,
                        ASSIGNING_AUTHORITY_HDR );
        Document vdmClinicalDataInsert = clinicalDataBuilder.createClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, 1, patient );

        return vdmClinicalDataInsert;
    }


    @SuppressWarnings( "unchecked" )
    protected Document createAndAssertDomainData( String templateId, String createRequestXml, String requestId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );
        Document clinicalDataDocument = requestProcessor.createClinicalData( createRequestXml, templateId, requestId );
        assertNotNull( clinicalDataDocument );

        // Check for an empty error section
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        Element errorSection = errorSections.get( 0 );
        assertTrue( errorSection.content().size() == 0 );

        List<Element> errors = clinicalDataDocument.selectNodes( ERROR_SECTION_ERRORS_XPATH );
        assertTrue( errors.size() == 0 );

        List<Element> warnings = clinicalDataDocument.selectNodes( ERROR_SECTION_WARNINGS_XPATH );
        assertTrue( warnings.size() == 0 );

        List<Element> fatalErrors = clinicalDataDocument.selectNodes( ERROR_SECTION_FATAL_ERRORS_XPATH );
        assertTrue( fatalErrors.size() == 0 );

        return clinicalDataDocument;
    }


    private Document readClinicalData( String patientIdentifier )
        throws Exception
    {
        Map<String, String> assigningFacilityAndPatientIdentityMap = new HashMap<String, String>();
        assigningFacilityAndPatientIdentityMap.put( ASSIGNING_FACILITY_HDR, patientIdentifier );

        Map<String, String> entryPointMap = new HashMap<String, String>();
        entryPointMap.put( "ID_2", "OutpatientMedicationPromise" );

        String filterXml = createOutpatientPharmacySinglePatientListDataFilter( assigningFacilityAndPatientIdentityMap,
                        "OutpatientMedicationPromise", ASSIGNINGAUTHORITY_DOD, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER, null, null );

        Document clinicalDataDocument = readAndAssertDomainData( assigningFacilityAndPatientIdentityMap, TemplateIdHelper.PHARMACY_READ_TEMPLATE_ID,
                        filterXml, TemplateIdHelper.RX_SINGLE_PATIENT_ALL_DATA_FILTER );

        List<Element> resultsResolvedIdentifiersList = clinicalDataDocument.selectNodes( XPATH_IDENTIFIERS );
        assertNotNull( resultsResolvedIdentifiersList );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( Map<String, String> assigningFacilityAndPatientIdentityMap, String templateId, String filter,
                    String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( DOMAINENTRYPOINT_XPATH );
        assertTrue( domainElements.size() > 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "deprecation" )
    private void doDelete( String patientId )
    {
        hdrJdbcTemplate.update( "DELETE FROM activity_log_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM PHARMACY_INSTRUCTION_V WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM OUTPPHARM_TREATMENT_FACTOR_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM MEDICATION_INSTRUCTION_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM dispense_comment_v where OUTPATIENT_MED_DSP_ID in ( select OUTPATIENT_MED_DSP_ID from outpatient_med_dsp_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "'))" );
        hdrJdbcTemplate.update( "DELETE FROM current_provider_comment_v where OUTPATIENT_MED_DSP_ID in ( select OUTPATIENT_MED_DSP_ID from outpatient_med_dsp_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "'))" );
        hdrJdbcTemplate.update( "DELETE FROM outpatient_med_dsp_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM patient_INSTRUCTION_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM expanded_patient_instruction_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM other_patient_instruction_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM cancel_comment_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM outppharm_sig_v WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
        hdrJdbcTemplate.update( "DELETE FROM OUTPATIENT_MED_PRM30_V WHERE OUTPATIENT_MED_PRM_ID IN (SELECT OUTPATIENT_MED_PRM_ID FROM OUTPATIENT_MED_PRM30_V WHERE PATIENT_IDENTITY = '"
                        + patientId + "')" );
    }
}
