/**
 *
 */


package gov.va.med.cds.integration;


import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * @author barryegbert
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
public abstract class AbstractFailingDataSourceTest
    extends
        AbstractBaseIntegrationCoreTest
{
//    protected ClinicalDataServiceInterface clinicalDataService; // injected
    protected RequestProcessorInterface requestProcessor; // injected
    
    protected RequestCreatorInterface requestCreator; // injected

    protected ErrorSectionCheckerInterface errorSectionChecker; // injected

    protected static Document readResult = null;


    @Test
    @Suite( order = 1, groups = { "brokentest" } )
    public void testFailingDataSourceReadRequests( )
        throws Exception
    {
        // create and store the specified observations. insure that they were stored properly.
        String createRequest = requestCreator.getCreateRequest();
        requestProcessor.createClinicalData( createRequest, requestCreator.getCreateTemplateId(), new UniqueIdentifier().toString() );

        // assertFalse(createResultValidator.hasErrors(createResult));

        // read the data
        String filterXml = requestCreator.getReadFilter();
        Document readResult = requestProcessor.readClinicalData( requestCreator.getReadTemplateId(), filterXml, "Filter100", new UniqueIdentifier()
                        .toString() );
      
        // delete the created observations
        String deleteXmlRequest = requestCreator.getDeleteRequest();
        requestProcessor.deleteClinicalData( deleteXmlRequest, requestCreator.getDeleteTemplateId(), new UniqueIdentifier().toString() );
    }


    @Resource
    public void setRequestCreator( RequestCreatorInterface requestCreator )
    {
        this.requestCreator = requestCreator;
    }


    @Resource
    public void setErrorSectionChecker( ErrorSectionCheckerInterface errorSectionChecker )
    {
        this.errorSectionChecker = errorSectionChecker;
    }


    protected abstract void checkForErrors( );

    public void setReadResult( Document readResult )
    {
        AbstractFailingDataSourceTest.readResult = readResult;
    }


    @AfterTestsOnce
    @Suite( groups = { "brokentest" } )
    public void afterAbstractFailingDataSourceTestMethodSetUp( )
        throws Exception
    {
        requestProcessor = null;
        requestCreator = null;
        errorSectionChecker = null;
    }


    public RequestProcessorInterface getRequestProcessor( )
    {
        return requestProcessor;
    }

    @Resource
    public void setRequestProcessor( RequestProcessorInterface requestProcessor )
    {
        this.requestProcessor = requestProcessor;
    }

}
