/**
 * 
 */
package gov.va.med.cds.filter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

/**
 * @author susarlan
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/filter/queryParameterContext.xml" } )
public class QueryParameterTest
{
	@Resource
	QueryParameter<String> queryParameter;
	
	@Test
    @Suite( groups = { "checkintest" } )
	public void testGetName() 
	{
		assertNull(queryParameter.getName());
		queryParameter.setName("param1");
		assertEquals(queryParameter.getName(), "param1");
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testGetValue() 
	{
		assertNull(queryParameter.getValue());
		queryParameter.setValue("Value1");
		assertEquals(queryParameter.getValue(), "Value1");
		assertTrue(queryParameter.getValue() instanceof String);
	}
}
