

package gov.va.med.cds.filter;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.xml.Assert;
import gov.va.med.cds.util.StreamUtil;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;


@RunWith( SuiteAwareRunner.class )
public class MultipleEntryPointFilterHelperTest
{
    private static Resource resource;
    private static ResourceLoader loader;

    private static String labFilter;
   
    private static MultipleEntryPointFilterHelper multipleEntryPointFilterHelper = new MultipleEntryPointFilterHelper();


    @BeforeClass
    @Suite( groups = "checkintest" )
    public static void beforeMultipleEntryPointFilterHelperTestSetUp( )
        throws IOException
    {
        loader = new DefaultResourceLoader();

        resource = loader.getResource( "classpath:gov/va/med/cds/filter/LabTestPromise.xml" );
        labFilter = StreamUtil.resourceToString( resource );

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetEntryPoint( )
    {
        Assert.assertEquals( multipleEntryPointFilterHelper.getEntryPoint( labFilter ), "LabTestPromise" );
    }

}
