

package gov.va.med.cds.filter;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.AbstractBaseIntegrationCoreTest;
import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.junit.runners.AfterTestsOnce;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/nonWeblogicHdr2DataSourceContext.xml",
                "classpath:gov/va/med/cds/filter/filterContextDBTest.xml" } )
public class LoadFilterSchemasIntoDBTest
    extends
        AbstractBaseIntegrationCoreTest
{
    private FilterFileSystemCacheManager filterFileSystemCacheManager;
    private FilterCachePersistenceInterface filterCachePersistence;

    private static final Log LOGGER = LogFactory.getLog( LoadFilterSchemasIntoDBTest.class );


    /**
     * Perform test initialization prior to methods getting called.
     */
    @BeforeTestsOnce
    @Suite( groups = { "prototypetest" } )
    public void beforeLoadFilterSchemasIntoDBTestClassSetUp( )
        throws Exception
    {
        assertNotNull( filterFileSystemCacheManager );
        assertNotNull( filterCachePersistence );
    }


    @AfterTestsOnce
    @Suite( groups = { "prototypetest" } )
    public void afterLoadFilterSchemasIntoDBTestClassTearDown( )
        throws Exception
    {
        filterFileSystemCacheManager = null;
        filterCachePersistence = null;
    }


    @Test
    @Suite( groups = { "prototypetest" } )
    public void persistFilterSchemasTest( )
    {
        Collection<String> filterIds = filterFileSystemCacheManager.getFilterIds();
        Collection<FilterMetaDataInterface> filterMetaDatas = new ArrayList<FilterMetaDataInterface>();
        FilterMetaDataInterface filterMetaData = null;

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "looping thru filterIds: " + filterIds );
        }

        for ( String filterId : filterIds )
        {
            if ( LOGGER.isDebugEnabled() )
            {
                LOGGER.debug( "\tRetrieving and Persisting filterSchema from persistance, Filter Id: " + filterId );
            }
            filterMetaData = filterFileSystemCacheManager.getFilterMetadata( filterId );
            filterMetaDatas.add( filterMetaData );
        }
        filterCachePersistence.replaceFilterPersistence( filterMetaDatas );

        List<String> persistedFilterIds = filterCachePersistence.getFilterIdentifiers();
        assertEquals( filterIds.size(), persistedFilterIds.size() );
        assertTrue( persistedFilterIds.containsAll( filterIds ) );
    }


    @Resource
    public void setFilterFileManager( FilterFileSystemCacheManager filterFileManager )
    {
        this.filterFileSystemCacheManager = filterFileManager;
    }


    @Resource
    public void setFilterCachePersistence( FilterCachePersistenceInterface filterCachePersistence )
    {
        this.filterCachePersistence = filterCachePersistence;
    }
}
