

package gov.va.med.cds.filter;


import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.List;
import java.util.Properties;


@RunWith( SuiteAwareRunner.class )
public class FilterServiceSimulatorTest
{
    private FilterServiceSimulator filterService = null;


    @Before
    @Suite( groups = "checkintest" )
    public void beforeFilterServiceSimulatorTest( )
    {
        filterService = new FilterServiceSimulator();
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsAlive( )
    {
        filterService.initialize();
        Assert.assertTrue( filterService.isAlive() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetTestFilters( )
        throws Exception
    {
        String vhimVerion = "Vhim_4_00";
        String filterId = "AA_SINGLE_PATIENT_ALL_DATA_FILTER";

        Properties properties = new Properties();
        properties.put( "path", "filtercache" );
        properties.put( "loadTestFilters", "true" );

        filterService.setTestFilters( properties );

        List<String> filterIds = ( List<String> )filterService.getActiveFilterIds( vhimVerion );
        Assert.assertTrue( filterIds.contains( filterId ) );

        List<String> vhimVersions = ( List<String> )filterService.getVhimVersions();
        Assert.assertTrue( vhimVersions.contains( vhimVerion ) );

        FilterMetaDataInterface filterMetaData = filterService.getFilterMetaData( filterId );
        Assert.assertEquals( filterId, filterMetaData.getFilterId() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetTestFiltersWithSingleMetaFile( )
        throws Exception
    {
        String vhimVerion = "Vhim_4_00";
        String filterId = "AA_SINGLE_PATIENT_ALL_DATA_FILTER";

        Properties properties = new Properties();
        properties.put( "path", "filtercache/AA_Single_Patient_All_Data_Filter.meta" );
        properties.put( "loadTestFilters", "true" );

        filterService.setTestFilters( properties );

        List<String> filterIds = ( List<String> )filterService.getActiveFilterIds( vhimVerion );
        Assert.assertTrue( filterIds.contains( filterId ) );

        List<String> vhimVersions = ( List<String> )filterService.getVhimVersions();
        Assert.assertTrue( vhimVersions.contains( vhimVerion ) );

        FilterMetaDataInterface filterMetaData = filterService.getFilterMetaData( filterId );
        Assert.assertEquals( filterId, filterMetaData.getFilterId() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetTestFiltersWithInvalidMetaFile( )
        throws Exception
    {
        String vhimVerion = "Vhim_4_00";
        String filterId = "AA_SINGLE_PATIENT_ALL_DATA_FILTER";

        Properties properties = new Properties();
        properties.put( "path", "../main/filtercache/AA_Single_Patient_All_Data_Filter_XXX.meta" );
        properties.put( "loadTestFilters", "true" );

        filterService.setTestFilters( properties );

        List<String> filterIds = ( List<String> )filterService.getActiveFilterIds( vhimVerion );
        Assert.assertFalse( filterIds.contains( filterId ) );
    }
}
