

package gov.va.med.cds.exception;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class InitializationExceptionTest
{
    @Test( expected = InitializationException.class )
    @Suite( groups = "checkintest" )
    public void testInitializationException( )
    {
        throw new InitializationException( ErrorCodeEnum.TEMPLATE_ID_NULL, "TemplateId is null" );
    }


    @Test( expected = InitializationException.class )
    @Suite( groups = "checkintest" )
    public void testInitializationExceptionWithThrowable( )
    {
        throw new InitializationException( ErrorCodeEnum.TEMPLATE_ID_NULL, new Exception() );
    }


    @Test( expected = InitializationException.class )
    @Suite( groups = "checkintest" )
    public void testInitializationExceptionWithThrowableAndCustomMsg( )
    {
        throw new InitializationException( ErrorCodeEnum.TEMPLATE_ID_NULL, new Exception(), "TemplateId is null" );
    }


    @Test( expected = InitializationException.class )
    @Suite( groups = "checkintest" )
    public void testInitializationExceptionWithErrorCode( )
    {
        throw new InitializationException( ErrorCodeEnum.TEMPLATE_ID_NULL );
    }

}
