

package gov.va.med.cds.builders;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilderInterface;

import java.util.Set;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


/**
 * Test utility that uses an internal ClinicalDataBuilder to construct dom4j data structures used within
 * the core tests.
 * 
 * @author VHAISLTALBOM
 *
 */
public class ClinicalDataGenerator
{

    private ClinicalDataBuilderInterface clinicalDataBuilder;


    public ClinicalDataGenerator( )
    {
    }


    public void setClinicalDataBuilder( ClinicalDataBuilderInterface clinicalDataBuilder )
    {
        this.clinicalDataBuilder = clinicalDataBuilder;
    }


    public ClinicalDataBuilderInterface getClinicalDataBuilder( )
    {
        return clinicalDataBuilder;
    }


    public Document setTemplateIdOnDocument( Document clinicalDataDocument, String templateId )
    {
        Element templateIdElement = getOrCreateElementFromParent( clinicalDataDocument.getRootElement(), "templateId" );
        templateIdElement.setText( templateId );

        return clinicalDataDocument;
    }


    private Element getOrCreateElementFromParent( Element parent, String elementName )
    {
        Element element = parent.element( elementName );
        if ( element == null )
        {
            element = DocumentHelper.createElement( "templateId" );
            parent.add( element );
        }

        return element;
    }


    public Element getClinicalDataPatient( Document clinicalDataDocument )
    {
        return clinicalDataDocument.getRootElement().element( "patient" );
    }


    // ALLERGIES
    public Document makeClinicalDataWithAllergy( )
    {
        return makeClinicalDataWithAllergies( 1 );
    }


    public Document makeClinicalDataWithAllergies( int count )
    {
        Document clinicalData = createClinicalData( TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID, count );
        return clinicalData;
    }


    // ALLERGY ASSESSMENTS
    public Document makeClinicalDataWithAllergyAssessment( )
    {
        return makeClinicalDataWithAllergyAssessments( 1 );
    }


    public Document makeClinicalDataWithAllergyAssessments( int count )
    {
        Document clinicalData = createClinicalData( TemplateIdHelper.ALLERGY_ASSESSMENT_CREATEORUPDATE_TEMPLATE_ID, count );
        return clinicalData;
    }


    // PHARMACY
    public Document makeClinicalDataWithOutpatientPharmacy( )
    {
        return makeClinicalDataWithOutpatientPharmacies( 1 );
    }


    public Document makeClinicalDataWithOutpatientPharmacies( int count )
    {
        Document clinicalData = createClinicalData( TemplateIdHelper.PHARMACY_CREATEORUPDATE_TEMPLATE_ID, count );
        return clinicalData;
    }


    // VITALS
    public Document makeClinicalDataWithVitalSignObservationEvent( )
    {
        return makeClinicalDataWithVitalSignObservationEvents( 1 );
    }


    public Document makeClinicalDataWithVitalSignObservationEvents( int count )
    {
        Document clinicalData = createClinicalData( TemplateIdHelper.VITALSIGNS_CREATEORUPDATE_TEMPLATE_ID, count );

        return clinicalData;
    }


    // LAB
    public Document makeClinicalDataWithLabTestPromise( )
    {
        return makeClinicalDataWithLabTestPromises( 1 );
    }


    public Document makeClinicalDataWithLabTestPromises( int count )
    {
        Document clinicalData = createClinicalData( TemplateIdHelper.LAB_CREATEORUPDATE_TEMPLATE_ID, count );

        return clinicalData;
    }


    public Document createClinicalData( String templateId, String aIdentity, String aAssigningFacility, String aAssigningAuthority )
    {
        Element patient = createPatient( aIdentity, aAssigningFacility, aAssigningAuthority );
        Document clinicalData = createClinicalData( templateId, patient );

        return clinicalData;
    }


    public Document createClinicalData( String templateId, int count )
    {
        return clinicalDataBuilder.createClinicalData( templateId, count );
    }


    public Document createClinicalData( String templateId )
    {
        return createClinicalData( templateId, 1 );
    }


    public Document createClinicalData( String templateId, Element patient )
    {
        return createClinicalData( templateId, 1, patient );
    }


    public Document createClinicalData( String aTemplateId, int count, Element patient )
    {
        return clinicalDataBuilder.createClinicalData( aTemplateId, count, patient );
    }


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet )
    {
        return clinicalDataBuilder.createClinicalData( domainEntryPointsSet, 1 );
    }


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int count, String identity, String assigningFacility,
                    String assigningAuthority )
    {

        Element patient = createPatient( identity, assigningFacility, assigningAuthority );
        return createClinicalData( domainEntryPointsSet, count, patient );

    }


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int count, Element patient )
    {

        return clinicalDataBuilder.createClinicalData( domainEntryPointsSet, count, patient );

    }


    public Document createClinicalData( Set<DomainEntryPoint> domainEntryPointsSet, int count )
    {
        return clinicalDataBuilder.createClinicalData( domainEntryPointsSet, count );
    }


    public Document createClinicalData( DomainEntryPoint aDomainEntryPoint )
    {
        return createClinicalData( aDomainEntryPoint, 1 );
    }


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, int count, String identity, String assigningFacility,
                    String assigningAuthority )
    {
        Element patient = createPatient( identity, assigningFacility, assigningAuthority );
        return createClinicalData( domainEntryPoint, count, patient );
    }


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, Element patient )
    {
        return clinicalDataBuilder.createClinicalData( domainEntryPoint, 1, patient );
    }


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, int count, Element patient )
    {
        return clinicalDataBuilder.createClinicalData( domainEntryPoint, count, patient );
    }


    public Document createClinicalData( DomainEntryPoint domainEntryPoint, int count )
    {
        return clinicalDataBuilder.createClinicalData( domainEntryPoint, count );
    }


    public Element createPatient( )
    {

        return BaseDatatypesBuilder.createHL72PersonIdentifier( "patient" );

    }


    public Element createPatient( String identity )
    {

        return BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", identity );
    }


    public Element createPatient( String identity, String assigningFacility )
    {

        return BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", identity, assigningFacility );
    }


    public Element createPatient( String identity, String assigningFacility, String assigningAuthority )
    {
        return BaseDatatypesBuilder.createHL72PersonIdentifier( "patient", identity, assigningFacility, assigningAuthority );

    }


    public PersonIdentifier buildPersonIdentifer( Element patient )
    {

        PersonIdentifier personIdentifier = new PersonIdentifier();
        personIdentifier.setAssigningAuthority( patient.elementText( "assigningAuthority" ) );
        personIdentifier.setAssigningFacility( patient.elementText( "assigningFacility" ) );
        personIdentifier.setIdentity( patient.elementText( "identity" ) );

        return personIdentifier;

    }


    public Element createRecordIdentifier( String identity, String namespaceid )
    {
        return BaseDatatypesBuilder.createHL72EntityIdentifier( "recordIdentifier", identity, namespaceid );
    }

}
