/**
 * 
 */
package gov.va.med.cds;

import static org.easymock.EasyMock.createNiceMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.replay;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.request.RequestProcessorInterface;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author susarlan
 *
 */
@RunWith( SuiteAwareRunner.class )
public class DefaultClinicalDatasServiceSynchronousTest 
{
    private static String FILTER_ID = "filterId";
    private static String REQUEST_ID = "requestId";
    private static String TEMPLATE_ID = "templateId";
    private static String FILTER_XML_REQUEST = "filterXmlRequest";
    
    private static Document WRITE_RESPONSE_DOCUMENT = DocumentHelper.createDocument();

    private RequestProcessorInterface requestProcessor = null;
    private DefaultClinicalDatasServiceSynchronous clinicalDataService = null;

    /*
     * Befor each test
     */
    @Before
    @Suite( groups = { "checkintest" } )
    public void before( )
    {
    	requestProcessor = createNiceMock(RequestProcessorInterface.class);
    	clinicalDataService = new DefaultClinicalDatasServiceSynchronous();
    	clinicalDataService.setRequestProcessor(requestProcessor);
    }

    
	@Test
    @Suite( groups = { "checkintest" } )
	public void testIsAlive() 
	{
		assertTrue(clinicalDataService.isAlive());
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testDeleteClinicalData() 
	{
		try
		{
    		String request = "deleteRequest";

    		expect(requestProcessor.deleteClinicalData(request, TEMPLATE_ID, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.deleteClinicalData(request, TEMPLATE_ID, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testReadClinicalData()
	{
		try
		{
    		expect(requestProcessor.readClinicalData(TEMPLATE_ID, FILTER_XML_REQUEST, FILTER_ID, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.readClinicalData(TEMPLATE_ID, FILTER_XML_REQUEST, FILTER_ID, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testReadClinicalDataNoFilterId() 
	{
		try
		{
    		expect(requestProcessor.readClinicalData(TEMPLATE_ID, FILTER_XML_REQUEST, null, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.readClinicalData(TEMPLATE_ID, FILTER_XML_REQUEST, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testUpdateClinicalData()
	{
		try
		{
    		String request = "updateRequest";

    		expect(requestProcessor.updateClinicalData(request, TEMPLATE_ID, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.updateClinicalData(request, TEMPLATE_ID, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testAppendClinicalData()
	{
		try
		{
    		String request = "appendRequest";

    		expect(requestProcessor.appendClinicalData(request, TEMPLATE_ID, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.appendClinicalData(request, TEMPLATE_ID, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

	@Test
    @Suite( groups = { "checkintest" } )
	public void testCreateClinicalData() 
	{
		try
		{
    		String request = "createRequest";

    		expect(requestProcessor.createClinicalData(request, TEMPLATE_ID, REQUEST_ID)).andReturn(WRITE_RESPONSE_DOCUMENT);
			replay(requestProcessor);
			assertNotNull(clinicalDataService.createClinicalData(request, TEMPLATE_ID, REQUEST_ID));
		}
		catch(Exception e)
		{
			fail();
		}
	}

}
