/**
 * 
 */
package gov.va.med.cds;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author VHAISLTALBOM
 *
 * This class is intended to give Unit tests the ability to inherit the ability to construct a basic data document with
 * a root element and perhaps a few high level values / elements set without requiring Spring configuration.
 */
@RunWith( SuiteAwareRunner.class )
public class AbstractBaseUnitCoreTest
{
    
    protected Document buildClinicalDataDocument(){
        return buildClinicalDataDocument(null, null);
    }
    
    protected Document buildClinicalDataDocument(String templateId, String requestId){
        
        return buildClinicalDataDocument(templateId, requestId, false);
    }
    
    
    protected Document buildClinicalDataDocument( String templateId, String requestId, boolean addPatient )
    {
        Namespace clinicalDataNamespace = DocumentHelper.createNamespace( "clinicaldata", "Clinicaldata" );
        Element clinicalDataElement = DocumentHelper.createElement( DocumentHelper.createQName( "ClinicalData", clinicalDataNamespace ) );

        if ( templateId != null )
        {
            clinicalDataElement.addElement( "templateId" ).addText( templateId );
        }

        if ( requestId != null )
        {
            clinicalDataElement.addElement( "requestId" ).addText( requestId );
        }

        if ( addPatient )
        {
            clinicalDataElement.addElement( "patient" );
        }

        return DocumentHelper.createDocument( clinicalDataElement );
    }
    
    //as more refactoring happens there will probably be a 'real' base test method added and this can be removed...
    @Test
    @Suite(groups="prototypetest") // test used only to avoid initialization errors when class loads without at least one test method.
    public void testEmpty( )
    {
        Assert.assertTrue(true);
    }
 
}
