

package gov.va.med.cds;


import gov.va.med.cds.builders.ClinicalDataGenerator;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Abstract base parent test for all of the tests within the core module.  Allows the ClinicalDataGenerator
 * and the use of the ClinicalDataBuilder to be configured in one place as well as provide inheritance
 * from the AbstractBastTest from the TestHarness.
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/clinicalDataBuilderContext.xml" } )
public class AbstractBaseIntegrationCoreTest
    extends
        AbstractBaseTest
{
    @Autowired
    protected ClinicalDataGenerator clinicalDataGenerator;


    public AbstractBaseIntegrationCoreTest( )
    {
        super();
    }


    protected AbstractBaseIntegrationCoreTest( String configFilePath )
    {
        super( configFilePath );
    }


    protected void printDocumentToSystemOut( String xmlString )
    {
        Document filterDocument = null;
        try
        {
            filterDocument = DocumentHelper.parseText( xmlString );
        }
        catch ( DocumentException e )
        {
            e.printStackTrace();
        }
        printDocumentToSystemOut( filterDocument );
    }


    protected void printDocumentToSystemOut( Document d )
    {
        OutputFormat format = OutputFormat.createPrettyPrint();
        //OutputFormat format = OutputFormat.createCompactFormat();
        XMLWriter writer;
        try
        {
            writer = new org.dom4j.io.XMLWriter( System.out, format );
            writer.write( d );
        }
        catch ( Exception e1 )
        {
            e1.printStackTrace();
        }
        System.out.println( "\n" );
    }


    protected List<Map<String, String>> getResolvedPatients( String[][] patientIdentifiers )
    {
        List<Map<String, String>> resolvedPatients = new ArrayList<Map<String, String>>();

        for ( String[] patientIdentifier : patientIdentifiers )
        {
            Map<String, String> patient = new HashMap<String, String>();
            patient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, patientIdentifier[0] );
            patient.put( FilterBuilder.ASSIGNING_FACILITY, patientIdentifier[1] );
            patient.put( FilterBuilder.IDENTITY, patientIdentifier[2] );

            resolvedPatients.add( patient );
        }

        return resolvedPatients;
    }


    protected List<Map<String, String>> getExcludeIdentifiers( String... excludeIdentifers )
    {
        List<Map<String, String>> excludeIdentifiers = new ArrayList<Map<String, String>>();

        Map<String, String> excludeIdentifier = new HashMap<String, String>();
        excludeIdentifier.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, excludeIdentifers[0] );
        excludeIdentifier.put( FilterBuilder.ASSIGNING_FACILITY, excludeIdentifers[1] );
        excludeIdentifiers.add( excludeIdentifier );

        return excludeIdentifiers;
    }


    //as more refactoring happens there will probably be a 'real' base test method added and this can be removed...
    @Test
    @Suite( groups = "prototypetest" )
    // test used only to avoid initialization errors when class loads without at least one test method.
    public void testEmpty( )
    {
        Assert.assertTrue( true );
    }

}
