package gov.va.med.cds.transaction;

import java.util.List;


/**
 * 
 * Provides the interface necessary through the Mbean implementation to allow access the list of validNonVistaSites
 * from the WebLogic console. This means that the administrator of the system can perform the methods specified here
 * from a WebLogic administrative web page.
 * 
 */
public interface ValidNonVistaSitesMBeanInterface
{

    /**
     * returns available list of validNonVistaSites  
     * 
     * @return list of validNonVistaSites
     */
    List<String> getValidNonVistaSites( );


    /**
     * add a validNonVistaSite to an existing list of validNonVistaSites
     * 
     * @param validNonVistaSite
     */
    void addValidNonVistaSite( String validNonVistaSite );


    /**
     * remove a validNonVistaSite from an existing list of validNonVistaSites
     * 
     * @param validNonVistaSite
     */
    void removeValidNonVistaSite( String validNonVistaSite );
}

