

package gov.va.med.cds.transaction;


import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.CensusException;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.valueobject.CensusMasterIngest;

import java.security.Timestamp;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;



/**
 * 
 * Performs Create/update/append/delete/read in a Spring initiated transaction context.
 * See gov.va.med.cds.config.transactionContext.xml for Spring DI and AOP/Tx details.
 * 
 */
public interface TransactionManagerInterface
{

    /**
     * Performs Read aganist a given clinical domain in the configured persistance manager associated with a database through
     * hibernate. 
     * @param filter Filter that is applied in sql related to start and end dates/vpid etc.
     * @return list of resultant data - from HDRII & VistA data sources.
     * @throws PersistenceException
     * 
     */
    List<Document> performReadOnClinicalData( CdsFilterInterface filter )
        throws PersistenceException;
    
    
    /**
     * Performs Read aganist a given clinical domain in the configured persistance manager associated with a database through
     * hibernate. 
     * @param filter Filter that is applied in sql related to start and end dates/vpid etc.
     * @return list of resultant data - from HDRII & VistA data sources.
     * @throws PersistenceException
     * 
     */
    List<Document> performReadOnClinicalData( String templateId, String requestId, CdsFilterInterface filter )
        throws PersistenceException;


    /**
     * Performs Create/update/append/delete in the specified clinical domain(s) in a Spring initiated transaction context (based on AOP pointcut mechanism
     * specified in transactionContext.xml) aganist a configured persistance manager associated with a
     * database through Hibernate.
     * @param operation The type of CUAD to be performed.
     * @param clinicalData Document that is the CUAD request data for one or more clinical domains.
     * @param templateId The template identifier of the incoming request.
     * 
     * @return The list of record identifier elements to be included in the response document.
     * @throws PersistenceException
     * 
     */
    List<Element> performCUADOnClinicalData( Operation operation, Document clinicalData, String templateId, String requestId )
        throws PersistenceException;
    
    /**
     * Query Census master table as well as Census Segment table
     * @param aTemplateId
     * @param aRequestId
     * @param aTimeStamp
     * @return ?????????
     * @throws PersistenceException
     */
    List<Element> performReadOnCensusMetaData(CensusMasterIngest aCensusMetaData) throws CensusException;
    
    /**
     * Perform update/create records in Census master table and Census Segment table
     * @param aOperation
     * @param aTemplateId
     * @param aRequestId
     * @param aTimeStamp
     * @return
     * @throws PersistenceException
     */
    String performCUADOnCensusMetaData(Operation aOperation, CensusMasterIngest aCensusMetaData) 
    	throws PersistenceException;
    
    
}
