

package gov.va.med.cds.tfs.util;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;


public class TemplateMetaDataHelper
{
    /**
     * Build a String array from a comma seperated list of VhimVersions enclosed in square brackets Ex: "[Vhim_4_00,
     * Vhim_4_01, Vhim_5_00]" => vhimVersion[0] = "Vhim_4_00", vhimVersion[1] = "Vhim_4_01", vhimVersion[2] =
     * "Vhim_5_00",
     * 
     * @param aCommaEncodedString
     * @return string array of supported vhim versions
     */
    public static String[] buildVhimVersions( String aCommaEncodedString )
    {
        String[] vhimVersions = aCommaEncodedString.replaceAll( "[\\[\\]]", "" ).trim().split( "," );

        return vhimVersions;
    }


    /**
     * Creates a HashSet of entry points from a comma seperated list of entry points enclosed in square brackets.
     * 
     * @param entryPoints entry points as a comma delimited string in square brackets..
     * @return doamin entry points set
     * @see #buildEntryPoints(String)
     */
    public static Set<DomainEntryPoint> buildEntryPoints( String entryPoints )
    {
        HashSet<DomainEntryPoint> entrypointSet = new HashSet<DomainEntryPoint>();
        String entryPointsLocal = null;
        if ( ( null != entryPoints ) && ( 0 < ( entryPointsLocal = entryPoints.trim() ).length() ) )
        {
            String[] templateEntryPoints = entryPointsLocal.replaceAll( "[\\[\\]]", "" ).trim().split( ", *" );
            for ( String entryPoint : templateEntryPoints )
            {
                addEntryPoint( entryPoint, entrypointSet );
            }
        }

        return entrypointSet;
    }


    /**
     * Adds a single entry point the this TemplateMetaData's entryPoint collection.
     * 
     * @param entryPoint the entry point to add.
     * @see #buildEntryPoints(String)
     */
    private static void addEntryPoint( String entryPoint, HashSet<DomainEntryPoint> entryPoints )
    {
        String templateEntryPoint = null;
        if ( null != entryPoint )
        {
            templateEntryPoint = entryPoint.trim();
        }

        if ( ( null != templateEntryPoint ) && ( 0 < templateEntryPoint.length() ) )
        {
            entryPoints.add( DomainEntryPoint.valueOf( entryPoint ) );
        }
    }


    /**
     * returns a collection of Strings pulled from the collection of Enums.
     * 
     * @param entryPoints the collection of Enums.
     */
    public static Collection<String> getEntryPoints( Set<DomainEntryPoint> entryPoints )
    {
        Collection<String> domainEntryPoints = new HashSet<String>();

        for ( DomainEntryPoint domainEntryPoint : entryPoints )
        {
            domainEntryPoints.add( domainEntryPoint.name() );
        }

        return domainEntryPoints;
    }
}
