

package gov.va.med.cds.tfs.util;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.EntryFilter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;


/**
 * Used to build domain entry points and VHIM versions for the Filter Cache Metadata.
 * 
 */
public class FilterMetaDataHelper
{
    /**
     * Build a String array from a comma separated list of VhimVersions enclosed in square brackets Ex: "[Vhim_4_00,
     * Vhim_4_01, Vhim_5_00]" =>
     * <li> vhimVersion[0] = "Vhim_4_00",
     * <li> vhimVersion[1] = "Vhim_4_01",
     * <li> vhimVersion[2] = "Vhim_5_00", <br>
     * 
     * @param String aCommaEncodedString which is the format in the metadata file.
     * @return String array of supported VHIM versions.
     */
    public static Set<String> buildVhimVersions( String aCommaEncodedString )
    {
        String[] vhimVersions = aCommaEncodedString.replaceAll( "[\\[\\]]", "" ).trim().split( "," );
        return new HashSet<String>( Arrays.asList( vhimVersions ) );
    }


    /**
     * Creates a HashSet of entry filters from a comma separated list of entry points enclosed in square brackets.
     * 
     * @param entryPoints entry points as a comma delimited string in square brackets..
     * @return entry filters set
     */
    public static Set<EntryFilter> buildEntryFilters( String entryPoints )
    {
        EntryFilter entryFilter;
        HashSet<EntryFilter> entryfilters = new HashSet<EntryFilter>();

        String entryPointsLocal = null;

        if ( ( null != entryPoints ) && ( 0 < ( entryPointsLocal = entryPoints.trim() ).length() ) )
        {
            String[] templateEntryPoints = entryPointsLocal.replaceAll( "[\\[\\]]", "" ).trim().split( ", *" );
            for ( String entryPoint : templateEntryPoints )
            {
                entryFilter = new EntryFilter();
                entryFilter.setXpath( null );
                entryFilter.setDomainEntryPoint( findEntryPoint( entryPoint ) );
                entryfilters.add( entryFilter );
            }
        }

        return entryfilters;
    }


    /**
     * Adds a single entry point to the FilterMetaData's entryPoint collection.
     * 
     * @param String entryPoint - is the entry point to add.
     */
    private static DomainEntryPoint findEntryPoint( String entryPoint )
    {
        String templateEntryPoint = null;
        DomainEntryPoint dep = null;
        if ( null != entryPoint )
        {
            templateEntryPoint = entryPoint.trim();
        }

        if ( ( null != templateEntryPoint ) && ( 0 < templateEntryPoint.length() ) )
        {
            dep = DomainEntryPoint.valueOf( entryPoint );
        }
        return dep;
    }


    public static EntryFilter getEntryFilter( DomainEntryPoint entryPoint )
    {
        EntryFilter filter = new EntryFilter();
        filter.setDomainEntryPoint( entryPoint );
        return filter;
    }
}
