

package gov.va.med.cds.template;


import java.util.List;


/**
 * 
 * Provides the interface necessary through the Mbean implementation to allow access to the template Cache parameters
 * from the WebLogic console. This means that the administrator of the system can perform the methods specified here
 * from a WebLogic administrative web page.
 * 
 */
public interface TemplateManagerMBeanInterface
{

    /**
     * Resizes the template cache and reloads it from the database.
     * 
     */
    void reinitializeTemplateCache( );


    /**
     * Empty the template cache.
     * 
     */
    void clearTemplateCache( );


    /**
     * Empty and reload the template cache from the database.
     * 
     * @param newSize new template cache threshold value
     */
    void resizeTemplateCache( int newSize );


    /**
     * Gets the no. of schemas contained in template cache map.
     * 
     * @return numberOfTemplates
     */
    int getNumberOfTemplatesLoadedIntoTemplateCache( );


    /**
     * Gets the size of template cache threshold.
     * 
     * @return templateCacheThreshold
     */
    int getTemplateCacheThreshold( );


    /**
     * gets available list of TemplateIds in Template cache
     * 
     * @return List of TemplateIds
     */
    List<String> getTemplateCacheTemplateIds( );
}
