/**
 * 
 */
package gov.va.med.cds.response.strategy;

import java.util.List;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.util.StringUtils;

/**
 * @author vhaislegberb
 * 
 * <p>In some cases, the VistA Generic Stored Procedure responds with multiple records that
 * constitutes a single result from the VistAa system. The result is split between multiple
 * records due to limitation that Cache / MUMPS systems have with regard to string lengths.
 * 
 * <p>This response strategy object assumes that all of the records passed into the format
 * response method are a single record and concatenates the response prior to sending it on. 
 *
 */
public class VistaGenericStoredProcedureSingleResponseStrategy
    implements
        VistaGenericStoredProcedureResponseStrategyInterface
{
    private static final String RESULTS = "results";
    
    private static final String GENERIC_OBSERVATION = "genericObservation";
    
    private static final String RECORD_IDENTIFIER = "recordIdentifier";
    
    private static final String IDENTITY = "identity";
    
    private static final String NAMESPACE_ID = "namespaceId";
    
    private static final String OBSERVATION_VALUE = "observationValue";

    /* (non-Javadoc)
     * @see gov.va.med.cds.response.strategy.VistaGenericStoredProcedureResponseStrategyInterface#formatResponse(java.util.List, java.lang.String, java.lang.String)
     */
    @Override
    public Element formatResponse( List<String> records, String patientId, String siteId )
        throws Exception
    {
        Element results = DocumentHelper.createElement( RESULTS );
        results.addElement( GENERIC_OBSERVATION );
        results.element( GENERIC_OBSERVATION ).addElement(RECORD_IDENTIFIER).addElement(IDENTITY).addText( patientId );
        if(StringUtils.hasLength( siteId ))
        {
            results.element( GENERIC_OBSERVATION ).element( RECORD_IDENTIFIER ).addElement(NAMESPACE_ID).addText( siteId );
        }
        
        // String buffer to hold the concatenated response.
        StringBuffer sbValue = new StringBuffer();
        
        for ( String value : records )
        {
            // concatenate the values and then add them to the 
            sbValue.append(value);
            
        }
        
        results.element( GENERIC_OBSERVATION ).addElement( OBSERVATION_VALUE ).addCDATA( sbValue.toString() );

        return results;
    }

}
