

package gov.va.med.cds.response.organizer.strategy;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.response.organizer.ResponseOrganazerException;

import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;

import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;

import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;

import weblogic.xml.jaxp.DOMFactoryProperties;


public class DefaultXQueryStrategy
    implements
        OrderingStrategyInterface
{
    private static final String BASE_URI = "xquery:root";
    private static final String EXPRESSION = "for $p in %s order by $p %s return $p";
    private Configuration configuration;
    private StaticQueryContext staticContext;
    private DynamicQueryContext dynamicContext;
    private Map<String,String> elementsToSortMap;


    /**
     * Orders XML document using XQuery.
     * @param sortExpression
     * @param responseDoc
     * @return sorted XML document
     * @throws ResponseOrganazerException
     */     
    @Override
    @SuppressWarnings( "unchecked" )
    public Document order( String sortExpression, String domainEntryPoint, Document responseDoc )
        throws ResponseOrganazerException
    {
        List list;

        String elementsToSort =(elementsToSortMap!= null)? elementsToSortMap.get( domainEntryPoint ): null;
        if ( elementsToSort == null )
        {
            throw new ResponseOrganazerException( ErrorCodeEnum.XQUERY_EXPRESSION_EXCEPTION, domainEntryPoint, elementsToSort, sortExpression );
        }
        
        try
        {
            String expression = String.format( EXPRESSION, elementsToSort, sortExpression  );
            XQueryExpression exp = staticContext.compileQuery( expression );
            // Base uri is specific to this operation - 'xquery:root'
            
            org.w3c.dom.Document doc = new DOMWriter().write( responseDoc );
            
            dynamicContext.setContextItem( new DocumentWrapper( doc, BASE_URI, configuration ) );
            list = exp.evaluate( dynamicContext);
            
            org.w3c.dom.Node parent = null;
            org.w3c.dom.Node firstChild = null;
            org.w3c.dom.Node n = null;
            
            for ( Object obj : list )
            {
                n = (org.w3c.dom.Node)obj;
                
                if(parent == null || firstChild == null)
                {
                    parent = n.getParentNode();
                    firstChild = parent.getFirstChild();
                }

                if( n != firstChild)
                {
                    parent.insertBefore( n, firstChild );
                }
                else
                {
                    firstChild = firstChild.getNextSibling();
                }
            }
            
            responseDoc = new DOMReader().read( doc );
        }
        catch ( Exception e )
        {
            throw new ResponseOrganazerException( ErrorCodeEnum.XQUERY_EXPRESSION_EXCEPTION, e, elementsToSort, sortExpression );
        }
        
        return responseDoc;
    }


    /**
     * @return the configuration
     */
    public Configuration getConfiguration( )
    {
        return configuration;
    }


    /**
     * @return the staticContext
     */
    public StaticQueryContext getStaticContext( )
    {
        return staticContext;
    }


    /**
     * @return the dynamicContext
     */
    public DynamicQueryContext getDynamicContext( )
    {
        return dynamicContext;
    }


    /**
     * @return the elementsToSort
     */
    public Map<String, String> getElementsToSortMap( )
    {
        return elementsToSortMap;
    }


    /**
     * @param configuration the configuration to set
     */
    public void setConfiguration( Configuration configuration )
    {
        this.configuration = configuration;
    }


    /**
     * @param staticContext the staticContext to set
     */
    public void setStaticContext( StaticQueryContext staticContext )
    {
        this.staticContext = staticContext;
    }


    /**
     * @param dynamicContext the dynamicContext to set
     */
    public void setDynamicContext( DynamicQueryContext dynamicContext )
    {
        this.dynamicContext = dynamicContext;
    }


    /**
     * @param elementsToSort the elementsToSort to set
     */
    public void setElementsToSortMap( Map<String, String> elementsToSortMap )
    {
        this.elementsToSortMap = elementsToSortMap;
    }


  

}
