/**
 * 
 */


package gov.va.med.cds.response;


import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.filter.CdsFilterInterface;


/**
 * @author VHAISLTALBOM
 *
 */
public class DefaultPatientIdentifierDocumentBuilder
    implements
        PatientIdentifierDocumentBuilderInterface
{
    protected ClinicalDataResponseInterface clinicalDataResponse = null;


    public void setClinicalDataResponse( ClinicalDataResponseInterface clinicalDataResponse )
    {
        this.clinicalDataResponse = clinicalDataResponse;
    }


    public Document createPatientWithIdentifiersDocument( CdsFilterInterface filter, String templateId, String requestId )
    {
        Document result = this.clinicalDataResponse.buildEmptyClinicalDocumentWithPatient( templateId, requestId );
        Element patient = this.clinicalDataResponse.getPatientElement( result );
        List<Element> resultantIdentifiers = filter.getResolvedIdentifiers();

        Element nationalId = filter.getNationalId();
        if ( nationalId != null )
        {
            this.clinicalDataResponse.addRequestedNationalId( result, nationalId.getText() );
            for ( Element resultantIdentifier : resultantIdentifiers )
            {
                patient.add( createIdentifierCollectionElement( "resultantIdentifiers", resultantIdentifier ) );
            }
        }
        else
        {
            Element edipiId = filter.getEdipi();
            if ( edipiId != null )
            {
                patient.add( createIdentifierCollectionElement( "requestedEdiPi", edipiId ) );
                patient.addElement( "resultantIdentifiers" ).add( createIdentifierCollectionElement( "resultantIdentifier", edipiId ) );
            }
            for ( Element resultantIdentifier : resultantIdentifiers )
            {
                patient.add( createIdentifierCollectionElement( "requestedResolvedIdentifiers", resultantIdentifier ) );
            }
            for ( Element resultantIdentifier : resultantIdentifiers )
            {
                patient.add( createIdentifierCollectionElement( "resultantIdentifiers", resultantIdentifier ) );
            }
        }

        List<Element> excludedIdentifiers = filter.getExcludedIdentifiers();
        for ( Element excludedIdentifier : excludedIdentifiers )
        {
            patient.add( excludedIdentifier );
        }

        return result;
    }


    protected Element createIdentifierCollectionElement( String elementName, Element element )
    {
        //the filter defines a different order than the template
        Element identifier = DocumentHelper.createElement( elementName );

        String identVal = element.elementText( "identity" );
        if ( identVal != null && !identVal.equals( "" ) )
        {
            identifier.addElement( "identity" ).setText( identVal );
        }

        String assignFacilityVal = element.elementText( "assigningFacility" );
        if ( assignFacilityVal != null && !assignFacilityVal.equals( "" ) )
        {
            identifier.addElement( "assigningFacility" ).setText( assignFacilityVal );
        }

        identifier.addElement( "assigningAuthority" ).setText( element.elementText( "assigningAuthority" ) );
        return identifier;
    }
}
