

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


public class VistaPersonNameUserType
    implements
        CompositeUserType
{

    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        Element name = null;
        VistaPersonName person = null;
        if ( rs != null && rs.getString( names[0] ) != null )
        {
            person = new VistaPersonName( rs.getString( names[0] ) );
        }
        else
        {
            return null;
        }

        if ( session.getEntityMode() == EntityMode.DOM4J )
        {
            if ( person.hasNameComponents() )
            {
                name = DocumentHelper.createElement( "name" );

                if ( person.getPrefix() != null && person.getPrefix().length() != 0 )
                    name.addElement( "prefix" ).addText( person.getPrefix() );
                if ( person.getGiven() != null && person.getGiven().length() != 0 )
                    name.addElement( "given" ).addText( person.getGiven() );
                if ( person.getMiddle() != null && person.getMiddle().length() != 0 )
                    name.addElement( "middle" ).addText( person.getMiddle() );
                if ( person.getFamily() != null && person.getFamily().length() != 0 )
                    name.addElement( "family" ).addText( person.getFamily() );
                if ( person.getSuffix() != null && person.getSuffix().length() != 0 )
                    name.addElement( "suffix" ).addText( person.getSuffix() );
                if ( person.getTitle() != null && person.getTitle().length() != 0 )
                    name.addElement( "title" ).addText( person.getTitle() );
            }
        }

        return name;
    }


    @Override
    public void nullSafeSet( PreparedStatement st, Object value, int index, SessionImplementor session )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object replace( Object original, Object target, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public Object assemble( Serializable cached, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SessionImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] {};
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING };
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    @Override
    public Class returnedClass( )
    {
        return VistaPersonName.class;
    }
}
