package gov.va.med.cds.persistence.hibernate.common;

import java.io.Serializable;

public class VistaPersonName implements Serializable
{
    private static final long serialVersionUID = -7944415414341369419L;

    private static final String DELIMETER = "\\^";

    private String identity;
    private String prefix;
    private String given;
    private String middle;
    private String family;
    private String suffix;
    private String title;
    private String stationNumber;
    static final int maxNumberOfTokens = 8;
    static final int minNumberOfTokens = 7;

    public VistaPersonName(String personWithDelimeters )
    {
       
        String[] persons = personWithDelimeters.split( DELIMETER, maxNumberOfTokens );

        if ( persons.length != minNumberOfTokens && persons.length != maxNumberOfTokens )
        {
            throw new IllegalArgumentException("Format of person with delimeters must follow the following format:\nidentity^family^given^middle^prefix^suffix^title[^namespaceid]");
        }
        
        identity = persons[0];
        family = persons[1];
        given = persons[2];
        middle = persons[3];
        prefix = persons[4];
        suffix = persons[5];
        title = persons[6];
        stationNumber = (persons.length == maxNumberOfTokens)?persons[maxNumberOfTokens - 1]:"";
    }
    
    /**
     * @return the identity
     */
    public String getIdentity( )
    {
        return identity;
    }

    /**
     * @return the prefix
     */
    public String getPrefix( )
    {
        return prefix;
    }

    /**
     * @return the given
     */
    public String getGiven( )
    {
        return given;
    }

    /**
     * @return the middle
     */
    public String getMiddle( )
    {
        return middle;
    }

    /**
     * @return the family
     */
    public String getFamily( )
    {
        return family;
    }

    /**
     * @return the suffix
     */
    public String getSuffix( )
    {
        return suffix;
    }

    /**
     * @return the title
     */
    public String getTitle( )
    {
        return title;
    }
    
    /**
     * @return the stationNumber
     */
    public String getStationNumber( )
    {
        return stationNumber;
    }

    /**
     * @param identity the identity to set
     */
    public void setIdentity( String identity )
    {
        this.identity = identity;
    }

    /**
     * @param prefix the prefix to set
     */
    public void setPrefix( String prefix )
    {
        this.prefix = prefix;
    }

    /**
     * @param given the given to set
     */
    public void setGiven( String given )
    {
        this.given = given;
    }

    /**
     * @param middle the middle to set
     */
    public void setMiddle( String middle )
    {
        this.middle = middle;
    }

    /**
     * @param family the family to set
     */
    public void setFamily( String family )
    {
        this.family = family;
    }

    /**
     * @param suffix the suffix to set
     */
    public void setSuffix( String suffix )
    {
        this.suffix = suffix;
    }

    /**
     * @param title the title to set
     */
    public void setTitle( String title )
    {
        this.title = title;
    }

    /**
     * @param title the stationNameber to set
     */
    public void setStationNameber( String stationNameber )
    {
        this.stationNumber = stationNameber;
    }
    
    /**
     * Checks to see whether any of the name compnonets have data in them.
     * @return True if there's data in any of the name compnents; otherwise false.
     */
    public boolean hasNameComponents()
    {
        return (family != null && family.length() != 0) || 
            (given != null && given.length() != 0) ||
            (middle != null && middle.length() != 0) ||
            (prefix != null && prefix.length() != 0) || 
            (suffix != null && suffix.length() != 0); 
    }
    

    /**
     * Checks to see whether the identity field was passed.
     * @return Returns true if the identity field was populated in the object;
     * otherwise false.
     */
    public boolean hasIdentity()
    {
        return (identity != null && identity.length() != 0); 
    }
    
    
}
