/**
 *
 */


package gov.va.med.cds.persistence.hibernate.common;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


public class VistaOutpatientPharmacyTreatmentFactorType
    extends
        AbstractPointInTimeUserType
{

    public Object getPropertyValue( Object value, int property )
        throws HibernateException
    {
        return null;
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] { "SERVICE_CONNECTED", "MILITARY_SEXUAL_TRAUMA", "AGENT_ORANGE_EXPOSURE", "IONIZING_RADIATION_EXPOSURE", "SouthwestAsiaConditions", "HEAD_ANDOR_NECK_CANCER", "COMBAT_VETERAN", "Proj112Shad" };
    }

    public String[] getPropertyDisplayNames( )
    {
        return new String[] { "SERVICE CONNECTED", "MILITARY SEXUAL TRAUMA", "AGENT ORANGE EXPOSURE", "IONIZING RADIATION EXPOSURE", "SOUTHWEST ASIA CONDITIONS", "HEAD AND/OR NECK CANCER", "COMBAT VETERAN", "PROJ 112/SHAD" };
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING };
    }


    public Object assemble( Serializable cached, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object assemble( Serializable cached, SessionImplementor sessionImplementor, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    public Serializable disassemble( Object value, SessionImplementor sessionImplementor )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        return false;
    }


    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner )
        throws HibernateException,
            SQLException
    {
        String[] propertyDisplayNames = getPropertyDisplayNames();
        if ( sessionImplementor.getEntityMode() == EntityMode.DOM4J )
        {
            Document document = DocumentHelper.createDocument();
            Element treatmentFactors = document.addElement( "treatmentFactors" );
            for ( int i = 0; i < names.length; i++ )
            {
                String treatmentFactorType = rs.getString( names[i] );
                if ( treatmentFactorType != null )
                {
                    Element treatmentFactor = treatmentFactors.addElement( "treatmentFactor" );
                    Element factor = treatmentFactor.addElement( "factor" );
                    Element code = factor.addElement( "code" );

                    Element factorValue = treatmentFactor.addElement( "factorValue" );
                    Element codeValue = factorValue.addElement( "code" );
                    Element displayText = factorValue.addElement( "displayText" );

                    if ( !rs.wasNull() )
                    {
                        code.setText( propertyDisplayNames[i] );

                        if ( treatmentFactorType.equals( "YES" ) )
                        {
                            codeValue.setText( "1" );
                            displayText.setText( "YES" );
                        }
                        else
                        {
                            codeValue.setText( "0" );
                            displayText.setText( "NO" );
                        }
                    }
                }
            }
            if ( treatmentFactors.hasContent() )
                return treatmentFactors.detach();
        }

        return null;
    }


    public void nullSafeSet( PreparedStatement st, Object value, int index, SessionImplementor sessionImplementor )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( "VistaReducedReadPersonNameUserType nullSafeSet method not implemented." );
    }


    public Class<PointInTime> returnedClass( )
    {
        return PointInTime.class;
    }


    public int[] sqlTypes( )
    {
        return new int[] { StandardBasicTypes.DATE.sqlType() };
    }

}
