

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.util.QueryCacheUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;


public class VistaMHVLabTestsUserType
    extends
        AbstractPointInTimeUserType
    implements
        CompositeUserType
{
    private final static Log LOGGER = LogFactory.getLog( VistaMHVLabTestsUserType.class );

    // no. of columns passing to the custom data type in Hibernate mapping file
    private static final int NO_OF_COLUMNS = 8;
    private static String[] PROPERTY_NAMES = new String[NO_OF_COLUMNS];
    private static Type[] PROPERTY_TYPES = new Type[NO_OF_COLUMNS];

    static
    {
        for ( int column = 0; column < NO_OF_COLUMNS; column++ )
        {
            PROPERTY_NAMES[column] = "";
            PROPERTY_TYPES[column] = StandardBasicTypes.STRING;
        }
    }


    @Override
    public Object assemble( Serializable cached, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SessionImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return PROPERTY_NAMES;
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return PROPERTY_TYPES;
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object object )
        throws HibernateException
    {
        if ( object == null )
        {
            return 0;
        }

        return object.hashCode();
    }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        Session mhvLaboratoryTes60DatatSession = session.getFactory().openSession();

        Element labTests = null;

        Map<String, LabTestsParsedFromGlobal> labTestsParsedFromGlobalMap = null;

        LabTestsParsedFromGlobal labTestsParsedFromGlobal = null;

        LabTestsParsedFromGlobal tempLabTestsParsedFromGlobal = null;

        VistaGlobalParser vistaGlobalParser = new VistaGlobalParser();

        // ConcatenatedResultExt
        // 122^30^CHOLESTEROL^
        // Value^FIELD_NUM^ColumnName^Message

        if ( rs == null )
        {
            return null;
        }
        else
        {
            int labTestCounter = 0;
            int chemistryResultsCounter = 1;

            Document document = DocumentHelper.createDocument();

            labTests = document.addElement( "labTests" );

            String concatenatedResultsExt = rs.getString( names[0] );
            String concatenatedResultsManualExt = rs.getString( names[1] );

            if ( null == concatenatedResultsExt )
            {
                return labTests;
            }

            if ( ( concatenatedResultsManualExt != null ) && ( !concatenatedResultsManualExt.equalsIgnoreCase( "null" ) ) )
            {
                labTestsParsedFromGlobalMap = vistaGlobalParser.parseGlobal( concatenatedResultsManualExt );
            }

            for ( String testValues : concatenatedResultsExt.split( "," ) )
            {

                String[] testValuesIndividual = testValues.split( "\\^" );

                if ( testValuesIndividual.length >= 3 && !testValuesIndividual[testValuesIndividual.length - 1].toUpperCase().contains( "ERROR" )
                                && isNumeric( testValuesIndividual[1].trim() ) )
                {
                    String labTestFieldNum = testValuesIndividual[1].trim();

                    if ( labTestsParsedFromGlobalMap != null )
                    {
                        labTestsParsedFromGlobal = labTestsParsedFromGlobalMap.get( labTestFieldNum );
                    }

                    try
                    {
                        List<Object> labTestElements = null;

                        if ( labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.isPanelTest() )
                        {
                            labTestElements = new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                            "MHVLabRead40011ForNLT.LabTestPromises.labTests.orderedTestCode3", "partOfPanelTest", new String( "%"
                                                            + labTestsParsedFromGlobal.getPartOfPanelTest() + "%" ) );
                        }
                        else
                        {
                            labTestElements = new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                            "MHVLabRead40011.LabTestPromises.labTests", "labTestFieldNum", new BigDecimal( labTestFieldNum ) );
                        }

                        for ( Object labTestElement : labTestElements /*mhvLaboratoryTes60DatatSession.getNamedQuery( "MHVLabRead40011.LabTestPromises.labTests" )
                                                                      .setParameter( "labTestFieldNum", new BigDecimal( labTestFieldNum ) ).list()*/)
                        {

                            labTestCounter++ ;

                            String siteSpecimen = null;

                            siteSpecimen = rs.getString( names[names.length - 1] );

                            if ( siteSpecimen == null )
                            {
                                break;
                            }

                            List<Object> chemistryResultElements = new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                            "labTests.chemistryResults", "labTestFieldNum", new BigDecimal( labTestFieldNum ), "siteSpecimen",
                                            new BigDecimal( siteSpecimen ) );

			    // There are no chemistry elements here, roll back the counter
                            if(chemistryResultElements.size() == 0)
                            {
                            	 --labTestCounter;
                            }

                            for ( Object chemistryResults : chemistryResultElements /* mhvLaboratoryTes60DatatSession.getNamedQuery( "labTests.chemistryResults" ).setParameter( "labTestFieldNum", new BigDecimal( labTestFieldNum ) )
                                                                                    .setParameter( "siteSpecimen", new BigDecimal( siteSpecimen ) ).list()*/)
                            {

                                if ( labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getPerormanceOrgCode() != null
                                                && labTestsParsedFromGlobal.getPerormanceOrgCode().length() > 0 )
                                {

                                    List<Object> performingOrganizationElements = new QueryCacheUtil().getNamedQueryList(
                                                    mhvLaboratoryTes60DatatSession,
                                                    "labTests.labTest.chemistryResults.chemistryResult.inst4PerformingOrganization",
                                                    "labTestFieldNum", new BigDecimal( labTestsParsedFromGlobal.getPerormanceOrgCode() ) );

                                    for ( Object performingOrganizationElement : performingOrganizationElements /*mhvLaboratoryTes60DatatSession.getNamedQuery( "labTests.labTest.chemistryResults.chemistryResult.inst4PerformingOrganization" )
                                                                                                                .setParameter( "labTestFieldNum", new BigDecimal( labTestsParsedFromGlobal.getPerormanceOrgCode() ) ).list()*/)
                                    {

                                        ( ( Element )chemistryResults ).add( ( Element )( ( ( Element )performingOrganizationElement ).clone() ) );

                                        break;
                                    }
                                }
                                else
                                {
                                    List<Object> performingOrganizationElements = new QueryCacheUtil().getNamedQueryList(
                                                    mhvLaboratoryTes60DatatSession,
                                                    "labTests.labTest.chemistryResults.chemistryResult.performingOrganization", "labTestFieldNum",
                                                    new BigDecimal( labTestFieldNum ) );

                                    for ( Object performingOrganizationElement : performingOrganizationElements )
                                    {

                                        ( ( Element )chemistryResults ).add( ( Element )( ( ( Element )performingOrganizationElement ).clone() ) );

                                        break;
                                        //TODO
                                        //performing organization should always be single and not multiples
                                    }
                                }

                                if ( !( tempLabTestsParsedFromGlobal == null )
                                                && !( labTestsParsedFromGlobal == null )
                                                && labTestsParsedFromGlobal.isPanelTest()
                                                && labTestsParsedFromGlobal.getPartOfPanelTest().equals(
                                                                tempLabTestsParsedFromGlobal.getPartOfPanelTest() ) )
                                {
                                    labTestCounter-- ;

                                    ++chemistryResultsCounter;

                                    ( ( Element )labTests.selectSingleNode( "labTests[" + labTestCounter + "]" ) )
                                                    .add( ( ( Element )chemistryResults ).detach() );
                                }
                                else
                                {
                                    chemistryResultsCounter = 1;

                                    ( ( Element )labTestElement ).add( ( Element )( ( ( Element )chemistryResults ).detach() ) );

                                    labTests.add( ( Element )labTestElement );

                                }

                                //labTestCounter++ ;

                                Node templabTestsLabTestsOrderedTestCode = ( Element )labTests.selectSingleNode( "labTests[" + labTestCounter
                                                + "]/orderedTestCode" );
                                //Node templabTestsLabTestsOrderedTestCode = ( Element )labTests.selectSingleNode( "//labTests/labTests[" + labTestCounter + "]/orderedTestCode" );

                                if ( ( templabTestsLabTestsOrderedTestCode == null ) && ( labTestsParsedFromGlobal != null )
                                                && ( labTestsParsedFromGlobal.getLoincCode() != null )
                                                && ( labTestsParsedFromGlobal.getNltReportedTestCode() != null )
                                                && ( !labTestsParsedFromGlobal.getLoincCode().equals( "" ) )
                                                && ( !labTestsParsedFromGlobal.getNltReportedTestCode().equals( "" ) ) )
                                {
                                    //for ( Object orderedTestCode : mhvLaboratoryTes60DatatSession.getNamedQuery( "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode1" ).setParameter( "loincCode", new BigDecimal( labTestsParsedFromGlobal.getLoincCode() ) )
                                    //                .setParameter( "workLoadCode", "%" + labTestsParsedFromGlobal.getNltReportedTestCode() + "%" ).list() )
                                    for ( Object orderedTestCode : new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                                    "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode1", "loincCode", new BigDecimal(
                                                                    labTestsParsedFromGlobal.getLoincCode() ), "workLoadCode", "%"
                                                                    + labTestsParsedFromGlobal.getNltReportedTestCode() + "%" ) )
                                    {
                                        ( ( Element )labTestElement ).add( ( Element )( ( ( Element )orderedTestCode ).detach() ) );

                                        break;
                                    }
                                }
                                else if ( ( templabTestsLabTestsOrderedTestCode == null ) && ( labTestsParsedFromGlobal != null )
                                                && ( labTestsParsedFromGlobal.getLoincCode() != null )
                                                && ( !labTestsParsedFromGlobal.getLoincCode().equals( "" ) ) )
                                {
                                    //for ( Object orderedTestCode : mhvLaboratoryTes60DatatSession.getNamedQuery( "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode2" ).setParameter( "loincCode", new BigDecimal( labTestsParsedFromGlobal.getLoincCode() ) ).list() )
                                    for ( Object orderedTestCode : new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                                    "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode2", "loincCode", new BigDecimal(
                                                                    labTestsParsedFromGlobal.getLoincCode() ) ) )
                                    {

                                        ( ( Element )labTestElement ).add( ( Element )( ( ( Element )orderedTestCode ).detach() ) );

                                        break;
                                    }
                                }
                                else if ( ( templabTestsLabTestsOrderedTestCode == null ) && ( labTestsParsedFromGlobal != null )
                                        && ( labTestsParsedFromGlobal.getNltOrderedTestCode() != null )
                                        && ( !labTestsParsedFromGlobal.getNltOrderedTestCode().equals( "" ) ) )
                                {
                                	//for ( Object orderedTestCode : mhvLaboratoryTes60DatatSession.getNamedQuery( "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode2" ).setParameter( "loincCode", new BigDecimal( labTestsParsedFromGlobal.getLoincCode() ) ).list() )
                                	for ( Object orderedTestCode : new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                            "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode4", "nltOrderedTestCode", 
                                            		"%"+labTestsParsedFromGlobal.getNltOrderedTestCode()+"%"))  
                                		{

                                			( ( Element )labTestElement ).add( ( Element )( ( ( Element )orderedTestCode ).detach() ) );

                                			break;
                                		}
                                }


                                Element tempChemistryResults = null;

                                if ( chemistryResultsCounter > 1 )
                                {
                                    tempChemistryResults = ( Element )labTests.selectSingleNode( "labTests[" + labTestCounter + "]/chemistryResults["
                                                    + chemistryResultsCounter + "]" );
                                }
                                else
                                {
                                    tempChemistryResults = ( Element )labTests.selectSingleNode( "labTests[" + labTestCounter + "]/chemistryResults" );
                                }

                                tempLabTestsParsedFromGlobal = labTestsParsedFromGlobal;

                                if ( tempChemistryResults != null )
                                {

                                    float observationValue;
                                    float referenceLow;
                                    float referenceHigh;
                                    float criticalLow;
                                    float criticalHigh;

                                    Node tempLabTestsChemistryResultsReferenceRange = tempChemistryResults.selectSingleNode( "referenceRange" );

                                    if ( tempLabTestsChemistryResultsReferenceRange != null )
                                    {
                                        if ( ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getReferenceLow() != null ) && ( !labTestsParsedFromGlobal
                                                        .getReferenceLow().equals( "" ) ) )
                                                        && ( ( labTestsParsedFromGlobal != null )
                                                                        && ( labTestsParsedFromGlobal.getReferenceHigh() != null ) && ( !labTestsParsedFromGlobal
                                                                        .getReferenceHigh().equals( "" ) ) ) )
                                        {
                                            tempLabTestsChemistryResultsReferenceRange.setText( labTestsParsedFromGlobal.getReferenceLow() + "-"
                                                            + labTestsParsedFromGlobal.getReferenceHigh() );
                                        }
                                        else if ( ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getReferenceLow() != null ) && ( !labTestsParsedFromGlobal
                                                        .getReferenceLow().equals( "" ) ) ) )
                                        {
                                            if ( !labTestsParsedFromGlobal.getReferenceLow().contains( ">" )
                                                            && isNumeric( labTestsParsedFromGlobal.getReferenceLow() ) )
                                            {
                                                labTestsParsedFromGlobal.setReferenceLow( ">" + labTestsParsedFromGlobal.getReferenceLow() );
                                            }

                                            tempLabTestsChemistryResultsReferenceRange.setText( labTestsParsedFromGlobal.getReferenceLow() );
                                        }
                                        else if ( ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getReferenceHigh() != null ) && ( !labTestsParsedFromGlobal
                                                        .getReferenceHigh().equals( "" ) ) ) )
                                        {
                                            if ( !labTestsParsedFromGlobal.getReferenceHigh().contains( "<" )
                                                            && isNumeric( labTestsParsedFromGlobal.getReferenceHigh() ) )
                                            {
                                                labTestsParsedFromGlobal.setReferenceHigh( "<" + labTestsParsedFromGlobal.getReferenceHigh() );
                                            }

                                            tempLabTestsChemistryResultsReferenceRange.setText( labTestsParsedFromGlobal.getReferenceHigh() );
                                        }
                                    }

                                    if ( tempChemistryResults.selectSingleNode( "observationUnits" ) != null )
                                    {
                                        if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getUnitsOfMeasure() != null )
                                                        && ( !labTestsParsedFromGlobal.getUnitsOfMeasure().equals( "" ) ) )
                                        {
                                            tempChemistryResults.selectSingleNode( "observationUnits/code" ).setText(
                                                            labTestsParsedFromGlobal.getUnitsOfMeasure() );
                                            tempChemistryResults.selectSingleNode( "observationUnits/displayText" ).setText(
                                                            labTestsParsedFromGlobal.getUnitsOfMeasure() );
                                        }
                                    }

                                    Node tempLabTestsChemistryResultsTestIdentifierCodeNode = tempChemistryResults
                                                    .selectSingleNode( "testIdentifier/code" );

                                    if ( ( tempLabTestsChemistryResultsTestIdentifierCodeNode == null ) && ( labTestsParsedFromGlobal != null )
                                                    && ( labTestsParsedFromGlobal.getLoincCode() != null )
                                                    && ( isNumeric( labTestsParsedFromGlobal.getLoincCode() ) ) )
                                    {
                                        List<Object> testIdentifiers = new QueryCacheUtil().getNamedQueryList( mhvLaboratoryTes60DatatSession,
                                                        "labTests.chemistryResults.testIdentifier", "loincCode",
                                                        BigDecimal.valueOf( Float.valueOf( labTestsParsedFromGlobal.getLoincCode() ) ) );
                                        for ( Object testIdentifier : testIdentifiers )
                                        {
                                            tempChemistryResults.add( ( ( Element )testIdentifier ).detach() );
                                        }
                                    }
                                    else if ( ( tempLabTestsChemistryResultsTestIdentifierCodeNode == null ) && testValuesIndividual[2] != null )
                                    {
                                        tempChemistryResults.selectSingleNode( "testIdentifier/displayText" )
                                                        .setText( testValuesIndividual[2].trim() );
                                        tempChemistryResults.selectSingleNode( "testIdentifier/originalText" ).setText(
                                                        testValuesIndividual[2].trim() );
                                    }

                                    tempChemistryResults.selectSingleNode( "observationValue" ).setText( testValuesIndividual[0].trim() );

                                    if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getReferenceLow() != null )
                                                    && ( !labTestsParsedFromGlobal.getReferenceLow().equals( "" ) ) )
                                    {
                                        tempChemistryResults.selectSingleNode( "referenceLow" ).setText( labTestsParsedFromGlobal.getReferenceLow() );
                                    }

                                    Node nodeReferenceLow = tempChemistryResults.selectSingleNode( "referenceLow" );

                                    if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getReferenceHigh() != null )
                                                    && ( !labTestsParsedFromGlobal.getReferenceHigh().equals( "" ) ) )
                                    {
                                        tempChemistryResults.selectSingleNode( "referenceHigh" )
                                                        .setText( labTestsParsedFromGlobal.getReferenceHigh() );
                                    }

                                    Node nodeReferenceHigh = tempChemistryResults.selectSingleNode( "referenceHigh" );

                                    if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getCriticalLow() != null )
                                                    && ( !labTestsParsedFromGlobal.getCriticalLow().equals( "" ) ) )
                                    {
                                        tempChemistryResults.selectSingleNode( "criticalLow" ).setText( labTestsParsedFromGlobal.getCriticalLow() );
                                    }

                                    Node nodeCriticalLow = tempChemistryResults.selectSingleNode( "criticalLow" );

                                    if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getCriticalHigh() != null )
                                                    && ( !labTestsParsedFromGlobal.getCriticalHigh().equals( "" ) ) )
                                    {
                                        tempChemistryResults.selectSingleNode( "criticalHigh" ).setText( labTestsParsedFromGlobal.getCriticalHigh() );
                                    }

                                    Node nodeCriticalHigh = tempChemistryResults.selectSingleNode( "criticalHigh" );

                                    if ( ( labTestsParsedFromGlobal != null ) && ( labTestsParsedFromGlobal.getValueInterpretation() != null )
                                                    && ( !labTestsParsedFromGlobal.getValueInterpretation().equals( "" ) ) )
                                    {
                                        tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText(
                                                        labTestsParsedFromGlobal.getValueInterpretation() );
                                    }
                                    else
                                    {

                                        if ( isNumeric( testValuesIndividual[0].trim() ) )
                                        {
                                            observationValue = Float.valueOf( testValuesIndividual[0].trim() );

                                            if ( nodeReferenceLow != null && isNumeric( nodeReferenceLow.getText() ) )
                                            {
                                                referenceLow = Float.valueOf( nodeReferenceLow.getText() );

                                                if ( nodeCriticalLow != null && isNumeric( nodeCriticalLow.getText() ) )
                                                {
                                                    criticalLow = Float.valueOf( nodeCriticalLow.getText() );

                                                    if ( observationValue < referenceLow && observationValue > criticalLow )
                                                    {
                                                        tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "L" );
                                                    }
                                                    else if ( observationValue <= criticalLow )
                                                    {
                                                        tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "LL" );
                                                    }
                                                }
                                                else if ( observationValue < referenceLow )
                                                {
                                                    tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "L" );
                                                }

                                            }

                                            if ( nodeReferenceHigh != null && isNumeric( nodeReferenceHigh.getText() ) )
                                            {
                                                referenceHigh = Float.valueOf( nodeReferenceHigh.getText() );

                                                if ( nodeCriticalHigh != null && isNumeric( nodeCriticalHigh.getText() ) )
                                                {
                                                    criticalHigh = Float.valueOf( nodeCriticalHigh.getText() );

                                                    if ( observationValue > referenceHigh && observationValue < criticalHigh )
                                                    {
                                                        tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "H" );
                                                    }
                                                    else if ( observationValue >= criticalHigh )
                                                    {
                                                        tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "HH" );
                                                    }

                                                }
                                                else if ( observationValue > referenceHigh )
                                                {
                                                    tempChemistryResults.selectSingleNode( "valueInterpretation" ).setText( "H" );
                                                }
                                            }
                                        }
                                    }

                                    Node observationStatus = tempChemistryResults.selectSingleNode( "observationStatus" );

                                    if ( ( null == labTestsParsedFromGlobal ) || ( null == labTestsParsedFromGlobal.getAmendedFlag() ) )
                                    {
                                        observationStatus.setText( "F" );
                                    }
                                    else
                                    {
                                        if ( ( labTestsParsedFromGlobal.getAmendedFlag().trim().equals( "1" ) ) )
                                        {
                                            if ( labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase( "pending" ) )
                                            {
                                                observationStatus.setText( "I" );
                                            }
                                            else
                                            {
                                                observationStatus.setText( "F" );
                                            }
                                        }
                                        else if ( labTestsParsedFromGlobal.getAmendedFlag().trim().equals( "2" ) )
                                        {
                                            if ( labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase( "pending" ) )
                                            {
                                                observationStatus.setText( "I" );
                                            }
                                            else
                                            {
                                                observationStatus.setText( "C" );
                                            }
                                        }
                                        else if ( labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase( "pending" ) )
                                        {
                                            observationStatus.setText( "I" );
                                        }
                                    }
                                }
                            }

                        }
                    }
                    catch ( Exception e )
                    {
                        //TODO - drop labTest element in the next maintainance release
                        Element labTestsElement = ( Element )labTests.selectSingleNode( "//labTests/labTests[" + labTestCounter + "]" );

                        if ( labTestsElement != null )
                        {
                            labTestsElement.detach();
                        }

                        --labTestCounter;
                    }
                }
            }
        }

        mhvLaboratoryTes60DatatSession.disconnect();

        return labTests;

    }


    @Override
    public void nullSafeSet( PreparedStatement st, Object value, int index, SessionImplementor session )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public Object replace( Object original, Object target, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public Class<String> returnedClass( )
    {
        return java.lang.String.class;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }

}
