

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


public abstract class SupplementalOxygenUserAbstractType
    implements
        CompositeUserType
{
    boolean isVWtype;


    public SupplementalOxygenUserAbstractType( boolean isVWtype )
    {
        this.isVWtype = isVWtype;
    }


    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        String supplementalO2UomColumnValues = ( rs != null ) ? rs.getString( names[0] ) : null;
        if ( supplementalO2UomColumnValues == null )
        {
            return null;
        }

        SupplementalOxygen supplementalO2 = new SupplementalOxygen( supplementalO2UomColumnValues );
        Element supplementalOxygenElement = null;

        if ( session.getEntityMode() == EntityMode.DOM4J )
        {
            if ( supplementalO2.hasNameComponents() )
            {
                supplementalOxygenElement = DocumentHelper.createElement( "supplementalOxygen" );
                String flowRateValue = supplementalO2.getFlowRateValue();
                if ( flowRateValue != null && flowRateValue.length() > 0 )
                {
                    Element flowRateValueElement = DocumentHelper.createElement( "flowRateValue" );
                    flowRateValueElement.addText( flowRateValue );
                    supplementalOxygenElement.add( flowRateValueElement );
                    String flowRateUnitCode = supplementalO2.getFlowRateUnitCode();
                    String flowRateUnitDisplayText = supplementalO2.getFlowRateUnitDisplayText();
                    String flowRateUnitCodingSystem = supplementalO2.getFlowRateUnitCodingSystem();
                    int flowRateUnitCodeLength = ( flowRateUnitCode != null ) ? flowRateUnitCode.length() : 0;
                    int flowRateUnitDisplayTextLength = ( flowRateUnitDisplayText != null ) ? flowRateUnitDisplayText.length() : 0;
                    int flowRateUnitCodingSystemLength = ( flowRateUnitCodingSystem != null ) ? flowRateUnitCodingSystem.length() : 0;
                    if ( ( !isVWtype && ( flowRateUnitCodeLength > 0 || flowRateUnitCodingSystemLength > 0 ) ) || flowRateUnitDisplayTextLength > 0 )
                    {
                        Element flowRateUnitElement = DocumentHelper.createElement( "flowRateUnit" );
                        supplementalOxygenElement.add( flowRateUnitElement );
                        if ( !isVWtype && flowRateUnitCodeLength > 0 )
                        {
                            Element flowRateUnitCodeElement = DocumentHelper.createElement( "code" );
                            flowRateUnitCodeElement.addText( flowRateUnitCode );
                            flowRateUnitElement.add( flowRateUnitCodeElement );
                        }
                        if ( flowRateUnitDisplayTextLength > 0 )
                        {
                            Element flowRateUnitDisplayTextElement = DocumentHelper.createElement( "displayText" );
                            flowRateUnitDisplayTextElement.addText( flowRateUnitDisplayText );
                            flowRateUnitElement.add( flowRateUnitDisplayTextElement );
                        }
                        if ( !isVWtype && flowRateUnitCodingSystemLength > 0 )
                        {
                            Element flowRateUnitCodingSystemElement = DocumentHelper.createElement( "codingSystem" );
                            flowRateUnitCodingSystemElement.addText( flowRateUnitCodingSystem );
                            flowRateUnitElement.add( flowRateUnitCodingSystemElement );
                        }
                    }
                }

                String concentrationValue = supplementalO2.getConcentrationValue();
                if ( concentrationValue != null && concentrationValue.length() > 0 )
                {
                    Element concentrationValueElement = DocumentHelper.createElement( "concentrationValue" );
                    concentrationValueElement.addText( concentrationValue );
                    supplementalOxygenElement.add( concentrationValueElement );
                    String concentrationUnitCode = supplementalO2.getConcentrationUnitCode();
                    String concentrationUnitDisplayText = supplementalO2.getConcentrationUnitDisplayText();
                    String concentrationUnitCodingSystem = supplementalO2.getConcentrationUnitCodingSystem();
                    int concentrationUnitCodeLength = ( concentrationUnitCode != null ) ? concentrationUnitCode.length() : 0;
                    int concentrationUnitDisplayTextLength = ( concentrationUnitDisplayText != null ) ? concentrationUnitDisplayText.length() : 0;
                    int concentrationUnitCodingSystemLength = ( concentrationUnitCodingSystem != null ) ? concentrationUnitCodingSystem.length() : 0;
                    if ( ( !isVWtype && ( concentrationUnitCodeLength > 0 || concentrationUnitCodingSystemLength > 0 ) )
                                    || concentrationUnitDisplayTextLength > 0 )
                    {
                        Element concentrationUnitElement = DocumentHelper.createElement( "concentrationUnit" );
                        supplementalOxygenElement.add( concentrationUnitElement );
                        if ( !isVWtype && concentrationUnitCodeLength > 0 )
                        {
                            Element concentrationUnitCodeElement = DocumentHelper.createElement( "code" );
                            concentrationUnitCodeElement.addText( concentrationUnitCode );
                            concentrationUnitElement.add( concentrationUnitCodeElement );
                        }
                        if ( concentrationUnitDisplayTextLength > 0 )
                        {
                            Element concentrationUnitDisplayTextElement = DocumentHelper.createElement( "displayText" );
                            concentrationUnitDisplayTextElement.addText( concentrationUnitDisplayText );
                            concentrationUnitElement.add( concentrationUnitDisplayTextElement );
                        }
                        if ( !isVWtype && concentrationUnitCodingSystemLength > 0 )
                        {
                            Element concentrationUnitCodingSystemElement = DocumentHelper.createElement( "codingSystem" );
                            concentrationUnitCodingSystemElement.addText( concentrationUnitCodingSystem );
                            concentrationUnitElement.add( concentrationUnitCodingSystemElement );
                        }
                    }
                }
            }
        }

        return supplementalOxygenElement;
    }


    @Override
    public void nullSafeSet( PreparedStatement st, Object value, int index, SessionImplementor session )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( "SupplementalOxygenUserAbstractType nullSafeSet method not implemented." );
    }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object replace( Object original, Object target, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( "SupplementalOxygenUserAbstractType setPropertyValue method not implemented." );
    }


    @Override
    public Object assemble( Serializable cached, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SessionImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] {};
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING };
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    @Override
    public Class returnedClass( )
    {
        return SupplementalOxygen.class;
    }
}
