package gov.va.med.cds.persistence.hibernate.common;

import java.io.Serializable;

public class SupplementalOxygen implements Serializable
{
    private static final long serialVersionUID = -7944415414341369419L;

    private static final String COLUMNS_DELIMETER = "\\^";
    private static final String SUPPLEMENTALO2_DELIMETER = " ";

    private String flowRateValue;
    private String flowRateUnitCode;
    private String flowRateUnitDisplayText;
    private String flowRateUnitCodingSystem;
    private String concentrationValue;
    private String concentrationUnitCode;
    private String concentrationUnitDisplayText;
    private String concentrationUnitCodingSystem;
    private String unitOfMeasure;
    
    static final int maxNumberOfTokens = 3;
    static final int minNumberOfTokens = 0;

    public SupplementalOxygen(String supplementalO2UomColumns )
    {
        String[] supplementalO2Uom = supplementalO2UomColumns.split( COLUMNS_DELIMETER );
        int supplementalO2UomLength = supplementalO2Uom.length;
        String supplementalO2WithDelimeters = (supplementalO2UomLength > 0) ? supplementalO2Uom[0].trim() : "";
        String uom = (supplementalO2UomLength > 1) ? supplementalO2Uom[1].trim() : "";
        String[] supplementalO2 = supplementalO2WithDelimeters.split( SUPPLEMENTALO2_DELIMETER, maxNumberOfTokens );
        int supplementalO2Length = supplementalO2.length;

        if ( supplementalO2Length < minNumberOfTokens || supplementalO2Length > maxNumberOfTokens )
        {
            throw new IllegalArgumentException("Format of Supplemental Oxygen with delimeters must follow the following format:\nFlowRateValue FlowRateUnit ConcentrationValue");
        }
        
        unitOfMeasure = (uom != null) ? uom.trim() : null;
        
        switch (supplementalO2Length)
        {
        	case 1:
                flowRateValue = null;
                flowRateUnitCode = null;
                concentrationValue = supplementalO2[0].trim();
        		break;
        		
        	case 2:
                flowRateValue = supplementalO2[0].trim();
                flowRateUnitCode = supplementalO2[1].trim();
                concentrationValue = null;
        		break;
        		
        	case 3:
                flowRateValue = supplementalO2[0].trim();
                flowRateUnitCode = supplementalO2[1].trim();
                concentrationValue = supplementalO2[2].trim();
        		break;
        		
        	default:
                flowRateValue = null;
                flowRateUnitCode = null;
                concentrationValue = null;
        		break;
        }
        
        flowRateUnitDisplayText = flowRateUnitCode;
        flowRateUnitCodingSystem = (flowRateUnitCode != null && flowRateUnitCode.length() > 0) ? "L" : null;
        
        int pctIndex = (concentrationValue != null) ? concentrationValue.indexOf("%") : -1;
        if (pctIndex >= 0)
        {
        	concentrationUnitCode = concentrationValue.substring(pctIndex).trim();
        	concentrationValue = concentrationValue.substring(0, pctIndex).trim();
        }
        else
        {
        	concentrationUnitCode = null;
        }
        concentrationUnitDisplayText = concentrationUnitCode;
        concentrationUnitCodingSystem = (concentrationUnitCode != null && concentrationUnitCode.length() > 0) ? "L" : null;
    }

	public String getFlowRateValue() {
		return flowRateValue;
	}

	public void setFlowRateValue(String flowRateValue) {
		this.flowRateValue = flowRateValue;
	}

	public String getFlowRateUnitCode() {
		return flowRateUnitCode;
	}

	public void setFlowRateUnitCode(String flowRateUnitCode) {
		this.flowRateUnitCode = flowRateUnitCode;
	}

	public String getFlowRateUnitDisplayText() {
		return flowRateUnitDisplayText;
	}

	public void setFlowRateUnitDisplayText(String flowRateUnitDisplayText) {
		this.flowRateUnitDisplayText = flowRateUnitDisplayText;
	}

	public String getFlowRateUnitCodingSystem() {
		return flowRateUnitCodingSystem;
	}

	public void setFlowRateUnitCodingSystem(String flowRateUnitCodingSystem) {
		this.flowRateUnitCodingSystem = flowRateUnitCodingSystem;
	}

	public String getConcentrationValue() {
		return concentrationValue;
	}

	public void setConcentrationValue(String concentrationValue) {
		this.concentrationValue = concentrationValue;
	}

	public String getConcentrationUnitCode() {
		return concentrationUnitCode;
	}

	public void setConcentrationUnitCode(String concentrationUnitCode) {
		this.concentrationUnitCode = concentrationUnitCode;
	}

	public String getConcentrationUnitDisplayText() {
		return concentrationUnitDisplayText;
	}

	public void setConcentrationUnitDisplayText(String concentrationUnitDisplayText) {
		this.concentrationUnitDisplayText = concentrationUnitDisplayText;
	}

	public String getConcentrationUnitCodingSystem() {
		return concentrationUnitCodingSystem;
	}

	public void setConcentrationUnitCodingSystem(
			String concentrationUnitCodingSystem) {
		this.concentrationUnitCodingSystem = concentrationUnitCodingSystem;
	}

	public String getUnitOfMeasure() {
		return unitOfMeasure;
	}

	public void setUnitOfMeasure(String unitOfMeasure) {
		this.unitOfMeasure = unitOfMeasure;
	}

	public boolean hasNameComponents()
	{
		return (flowRateValue != null && flowRateValue.length() > 0) ||
				(flowRateUnitCode != null && flowRateUnitCode.length() > 0) ||
				(concentrationValue != null && concentrationValue.length() > 0) ||
				(concentrationUnitCode != null && concentrationUnitCode.length() > 0);
	}
        
}
