/**
 * 
 */


package gov.va.med.cds.persistence.hibernate.common;


import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;

import javax.servlet.jsp.tagext.IterationTag;

import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.CustomType;
import org.hibernate.usertype.ParameterizedType;


/**
 * @author vhaislegberb
 *
 * This hibernate user type is used to support writing XML data to DOM model as 
 * CDATA as opposed to writing it out URL encoded. This is a requirement of 
 * clients that read XML data from CDS.
 */
public class Dom4jXmlTypeCustomType
    extends
        CustomType
    implements
        ParameterizedType
{

    private static final long serialVersionUID = 4126012687726205409L;

    public Dom4jXmlTypeCustomType( )
        throws MappingException
    {
        super( new Dom4jXmlTypeUserType() );
    }


    @Override
    public void setToXMLNode( Node node, Object value, SessionFactoryImplementor factory )
        throws HibernateException
    {
        // check for CDATA case.
        if ( node.getNodeType() == Node.ELEMENT_NODE && value != null && value instanceof Element && ( ( Element )value ).nodeCount() > 0 )
        {
        	Element targetElement = (Element)node;
        	Element valueElement = ((Element)value);
        	Iterator<Node> nodeIter = valueElement.nodeIterator();
        	Node childNode = null;
        	
        	while( nodeIter.hasNext() )
        	{
        		childNode = nodeIter.next();
        		if( childNode.getNodeType() == Node.CDATA_SECTION_NODE || childNode.getNodeType() == Node.ELEMENT_NODE )
            	{
    	            targetElement.add( (Node)childNode.clone() );
            	}
        	}
        }
        else
        {
            super.setToXMLNode( node, value, factory );
        }
    }


    @Override
    public void setParameterValues( Properties parameters )
    {

    	((Dom4jXmlTypeUserType)this.getUserType()).setParameterValues(parameters);

    }
    
    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
    	return ((Dom4jXmlTypeUserType)this.getUserType()).nodeToXMLString(xml);
	}


    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        return ( ( Dom4jXmlTypeUserType )this.getUserType() ).nullSafeGet( rs, names, session, owner );
    }


    @Override
    public Object nullSafeGet( ResultSet rs, String columnName, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        return ( ( Dom4jXmlTypeUserType )this.getUserType() ).nullSafeGet( rs, new String[] { columnName }, session, owner );
    }

}
