/**
 * 
 */
package gov.va.med.cds.persistence.hibernate.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.usertype.UserCollectionType;

/**
 * @author vhaislegberb
 *
 */
public class Dom4JAbleListType implements UserCollectionType {

	private static final long serialVersionUID = -1003786001532870988L;
	
	@SuppressWarnings("rawtypes")
	@Override
	public Object indexOf(Object collection, Object element) {
		if(collection instanceof Element && element instanceof Element)
		{
			Element parent = (Element)collection;
			Element child = (Element) element;
			
			List children = parent.elements(child.getName());
			if(children != null && children.size() > 0)
			{
				for(int i = 0; i < children.size(); i++)
				{
					if(element.equals(children.get(i))) // TODO get fancier here to make this actually work. Not sure that this will ever match.
					{
						return i;
					}
				}
			}
		}

		throw new IllegalArgumentException("This type should only be used for List mappings in Dom4J Entity Mode.");
	}
	
	@SuppressWarnings("rawtypes")
	@Override
	public Iterator getElementsIterator(Object collection) {
		
		if( collection instanceof Element )
		{
			return ((Element) collection).elements().iterator();
		}
		
		throw new IllegalArgumentException("This type should only be used for List mappings in Dom4J Entity Mode.");
		
	}

	@Override
	public PersistentCollection instantiate(SessionImplementor session,
			CollectionPersister persister) throws HibernateException {
		return new ListIndexablePersistentElementHolder(session, DocumentHelper.createElement(persister.getElementNodeName()));
	}

	@SuppressWarnings("rawtypes")
	@Override
	public boolean contains(Object collection, Object entity) {
		
		if(collection instanceof Element && entity instanceof Element)
		{
			Element parent = (Element)collection;
			Element child = (Element) entity;
			
			List children = parent.elements(child.getName());
			if(children != null && children.size() > 0)
			{
				for(int i = 0; i < children.size(); i++)
				{
					if(entity.equals(children.get(i))) // TODO get fancier here to make this actually work.
					{
						return true;
					}
				}
			}
		}
		
		throw new IllegalArgumentException("This type should only be used for List mappings in Dom4J Entity Mode.");
	}

	@Override
	public Object replaceElements(Object original, Object target,
			CollectionPersister persister, Object owner, Map copyCache,
			SessionImplementor session) throws HibernateException {
		
		if(original instanceof Element && target instanceof Element)
		{
			Element targetElement = (Element)target;
			Iterator iter = targetElement.elementIterator();
			while(iter.hasNext())
			{
				((Element)iter.next()).detach();
			}
			
			Element originalElement = (Element)original;
			iter = originalElement.elementIterator();
			while(iter.hasNext())
			{
				targetElement.add(((Element)iter.next()).detach());
			}
			
			return target;
		}
		
		throw new IllegalArgumentException("This type should only be used for List mappings in Dom4J Entity Mode.");
	}

	@Override
	public PersistentCollection wrap(SessionImplementor session,
			Object collection) {
		if(collection instanceof Element)
		{
			ListIndexablePersistentElementHolder elementHolder = new ListIndexablePersistentElementHolder(session, (Element)collection);
			return elementHolder;
		}
		throw new IllegalArgumentException("This type should only be used for List mappings in Dom4J Entity Mode.");
	}

	@Override
	public Object instantiate(int anticipatedSize) {
		return DocumentHelper.createElement("element");
	}

}

