

package gov.va.med.cds.persistence.hibernate;



import org.dom4j.Element;
import org.hibernate.Session;


public class WriteableDMPSurveyPersistenceManager
    extends
        WriteableSurveyPersistenceManager
{

    /**
     * Handles hibernate HDRII create processing.
     * 
     * @param session - active hibernate session.
     * @param aObject - create request.
     */
	@Override
    protected String createData( Session session, Object aObject )
    {
        Element surveyResponse = (Element)aObject;

        validateAndRetrieveVendor( session, surveyResponse );
        validateAndRetrieveFacility( session, surveyResponse );
		retrieveOrStore(session, surveyResponse, "survey");
		verifyStoringQuestionsAndAnswers( session, surveyResponse );
        return session.save( surveyResponse ).toString();
    }
    
    
    /**
     * RQ 279.8	
     * HDR shall only persist HTH survey data to the HDR DB when the survey status is �ACCEPTED� 
     * and the data contains an answer for every question for the corresponding survey version.
     * 
     * @param session
     * @param aSurveyResponse
     */
    private void verifyStoringQuestionsAndAnswers( Session session, Element aSurveyResponse )
    {
        if ( ! aSurveyResponse.elementText("responseStatus").equalsIgnoreCase("ACCEPTED") )
        {
        	aSurveyResponse.remove( aSurveyResponse.element( "surveyQuestionsAndAnswersWithScores" ) );
        }
    }
    
}
