package gov.va.med.cds.persistence.hibernate;

import static gov.va.med.cds.exception.ErrorCodeEnum.HDRII_OPERATION_FAILED;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.CensusException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.CensusSurveyConstant;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.valueobject.CensusMasterIngest;

//import java.util.Iterator;
import java.util.Iterator;
import java.util.List;
//import java.util.logging.Level;
//import java.util.logging.Logger;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Example;
import org.hibernate.exception.ConstraintViolationException;

public class WriteableCensusSurveyPersistenceManager extends
    AbstractHibernatePersistenceManager implements
    WritePersistenceManagerInterface 
{

		//            private static final String PATIENT = "patient";
//            private static final String surveyPatient = "surveyPatient";
	private List<BooleanRuleInterface> rules;
    private String cdsAppName;
        
    public boolean isApplicable(Object critera) throws PersistenceException {
            boolean b = false;
            for (BooleanRuleInterface r : rules) {
                    b = r.evaluate(critera);
                    if (b) {
                        	break;
                    }
            }

            return b;
    }
    public String performCUADOnClinicalData(String templateId, Operation operation, Object aObject, String domainEntryPoint)
                                    throws PersistenceException {
                return "";
    }
    
                
                /**
     * Handles the CUAD requests and applies the transaction to the data-source as directed by the request type.
     * 
     * @param templateId The identifier of the template being created, updated, appended, or deleted.
     * @param requestType - request type could be Create, Update, Append and Delete.
     * @param object - CDM objects to apply to the data-source.
     */
    //@Override
    public String performCUADOnPatientsData( String templateId, String aRequestId, Operation aOperation, Object aObject, DomainEntryPoint domainEntryPoint )
        throws PersistenceException
    {
        Session session = null;
        String resultId = "";
        String censusMasterID = null;
        String censusSegmentID = null;
        List<Element> patientsList = null;
        Element patientsElement = (Element)aObject;
        patientsList = patientsElement.elements("patient");
        
        try 
        {
            session = getSessionFactory(templateId).getCurrentSession();
            
            censusMasterID = retrieveOrStoreCensusMasterIngest(session, patientsElement);
            censusSegmentID = retrieveOrStoreMasterSegment(session, patientsElement, censusMasterID);

            if ( LOGGER.isDebugEnabled() ) 
            {
                LOGGER.debug(gov.va.med.cds.util.LogMessageUtil.buildMessage( templateId, aRequestId, cdsAppName, "Storing Census records for:" + patientsList.size() + " patients" ));
            }
            
            int batchCount = 0;

            double start= System.currentTimeMillis();

            Element censusRecord = null;
            for ( int i = 1; i <= patientsList.size(); i++ )
            {
                batchCount++;
                Element patientElement = (Element) patientsList.get( i-1 ).clone();
                patientElement.detach();
                
                List<Element> clinicalRecords = domainEntryPoint.getClinicalRecords( patientElement );
                censusRecord = clinicalRecords.get( 0 );
                censusRecord.addElement( "requestId" ).addText( aRequestId );
                
                	Element censusSegmentIDElement= DocumentHelper.createElement("censusSegmentID");
                    censusSegmentIDElement.setText(censusSegmentID);
                    censusRecord.add(censusSegmentIDElement);
                    
                    Element censusMasterIDElement= DocumentHelper.createElement("censusMasterID");
                    censusMasterIDElement.setText(censusMasterID);
                    censusRecord.add(censusMasterIDElement);
                
                resultId = createData( session, censusRecord );
                if ( batchCount % 100 == 0 ) //100, same as the JDBC batch size
                { 
                    if ( LOGGER.isDebugEnabled() ) 
                    {
                        LOGGER.debug( "Writing batch of 100 census records: " + i );
                    }
                    //flush a batch of inserts and release memory:
                    session.flush();
                    session.clear();
                }
            }
            
            double end = ( System.currentTimeMillis() - start );
            if ( LOGGER.isDebugEnabled() ) 
            {
                LOGGER.debug( "===========================================================================\n");
                LOGGER.debug( "Total time storing census records: " + end + "\n");
                LOGGER.debug( "Total item or record count: " + batchCount + "\n" );
                LOGGER.debug( "===========================================================================\n");
            }
            //System.out.println("===========================================================================\n");
            //System.out.println("Total item or record count: " + batchCount + "\n");
            //System.out.println("Total time storing census records: " + end + "\n");
            //System.out.println("===========================================================================\n");
                
        }
        // try to figure out what caused the violation
        catch ( ConstraintViolationException e ) 
        {
            throw new HibernateConstraintViolationException(e);
        }
        // already handled and turned into one of ours so rethrow it
        catch ( PersistenceException e ) 
        {
            throw e;
        }
        // any other problems are just big and will require someone to look at
        // so check log file
        catch ( Exception e ) 
        {
            String rootCauseMessage = ExceptionUtils.getRootCause(e) == null ? e
                    .getMessage() : ExceptionUtils.getRootCause(e).getMessage();
            throw new PersistenceException( HDRII_OPERATION_FAILED, e, aOperation.name(), rootCauseMessage, domainEntryPoint.getName() );
        }
        
        return resultId;
    }

    @Override
	public List<Element> performReadOnCensusMetaData(CensusMasterIngest censusMasterIngest) throws CensusException {
		// TODO Auto-generated method stub
    	Session aSession = getSessionFactory(censusMasterIngest.getTemplateId()).getCurrentSession();
		Element incomingCensusElement= DocumentHelper.createElement("censusMasterIngest");
		// Add ingestStatus criteria		
//		Element ingestStatusElement= DocumentHelper.createElement("ingestStatus");
//        		String lastSegment = response.element("segment").element("last").getText();
//		ingestStatusElement.setText(censusMasterIngest.getIngestStatus());
//		incomingCensusElement.add(ingestStatusElement);
		incomingCensusElement.addElement("datetime").setText(censusMasterIngest.getSegmentDatetime());
		incomingCensusElement.addElement("vendorName").setText(censusMasterIngest.getVendorName());
//		Element vendorElement= DocumentHelper.createElement("vendorName");
//		vendorElement.setText(censusMasterIngest.getVendorName());
//		incomingCensusElement.add(vendorElement);
		
		Criteria aCriteria = aSession.createCriteria("censusMasterIngest");
		aCriteria.add(Example.create(incomingCensusElement));
		
		//Criteria aCriteria = aSession.createCriteria("censusMasterSegment");
		List<Element> results = aCriteria.list();
//		iterateAllElements(results);
//		int size = results.size();
//		System.out.println("Number of MasterSegments: " + size);
		return results;
	}
	@Override
	public String performCUADOnCensusMetaData(Operation aOperation, CensusMasterIngest censusMasterIngest) throws PersistenceException {
		// TODO Auto-generated method stub
		Session session = getSessionFactory(censusMasterIngest.getTemplateId()).getCurrentSession();
		String censusMasterId = performCUADOnCensusMasterIngest(session, censusMasterIngest);
		censusMasterIngest.setCensusMasterId(censusMasterId);
		String censusSegmentId = performCUADOnCensusMasterSegment(session, censusMasterIngest);
		censusMasterIngest.setCensusSegmentId(censusSegmentId);
		return censusMasterIngest.getCurrentSegmentNo();
	}
            
                

    /**
     * Handles hibernate HDRII create processing.
     * 
     * @param session - active hibernate session.
     * @param aObject - create request.
     */
                
                
                //@Override
    protected String createData( Session session, Object aObject )
    {
        Element surveyResponse = (Element)aObject;
        
        
        /* Following is for the multi-table relational solution 

        validateAndRetrieveCensusVendor( session, surveyResponse );
        checkVendorTotalTime += (System.currentTimeMillis()-start);
        
        start= System.currentTimeMillis();
        validateAndRetrieveFacility( session, surveyResponse );
        vendorFacilityTotalTime += (System.currentTimeMillis() -start);
        
        start= System.currentTimeMillis();
        retrieveOrStoreData(session, surveyResponse, "survey");
                                saveSurveyTotalTime += (System.currentTimeMillis()-start);
                                
                                start= System.currentTimeMillis();
                                retrieveOrStoreData(session, surveyResponse, "surveyPatient");
                                savePatientTotalTime += (System.currentTimeMillis()-start);
                                
                                start= System.currentTimeMillis();
                                validateAndRetrieveCCFacility( session, surveyResponse );
                                ccFacilityTotalTime += (System.currentTimeMillis()-start);
                                
                                start= System.currentTimeMillis();
                                retrieveOrStoreData(session, surveyResponse, "careCoordinator");
                                saveCCTotalTime+= (System.currentTimeMillis()-start);
                                
                                start= System.currentTimeMillis();
                                storeModalities( session, surveyResponse );
                                saveModalityTotalTime += (System.currentTimeMillis()-start);
                                */
                                
        return session.save( surveyResponse ).toString();
    } 
                

        @SuppressWarnings("unchecked")
        protected String retrieveOrStoreMasterSegment(Session session, Element response, String censusMasterId) {
        		String censusSegmentId = null;
                
                CensusMasterIngest censusMasterIngest = new CensusMasterIngest();
                 
                censusMasterIngest.setCensusMasterId(censusMasterId);
                String currentSegment = response.element("segment").element("current").getText();
                censusMasterIngest.setCurrentSegmentNo(currentSegment);
                censusMasterIngest.setCurrentSegmentProcessStatus(CensusSurveyConstant.INGEST_COMPLETE);
                return performCUADOnCensusMasterSegment(session, censusMasterIngest);
                
        }
                
        private String performCUADOnCensusMasterSegment(Session session, CensusMasterIngest censusMasterIngest){
        	
        	String censusSegmentId = null;	
        	List<Element> results = null;
	        	Element incomingSegmentElement= DocumentHelper.createElement("censusMasterSegment");
	            Element currentElement= DocumentHelper.createElement("currentSegment");
	                
                currentElement.setText(censusMasterIngest.getCurrentSegmentNo());
                incomingSegmentElement.add(currentElement);
                
                incomingSegmentElement.addElement("censusMasterID").addText(censusMasterIngest.getCensusMasterId());

                incomingSegmentElement.addElement("processStatus").addText(censusMasterIngest.getCurrentSegmentProcessStatus());
                
                Criteria criteria = session.createCriteria("censusMasterSegment");
                criteria.add(Example.create(incomingSegmentElement));
                try {
                	results = criteria.list();
                } catch (org.hibernate.exception.GenericJDBCException e) {
                    throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
                }
                
                if (results.size() < 1) {

                        censusSegmentId = session.save(incomingSegmentElement).toString();
                } else {
                        //duplicate segment
                        throw new ReadException(ErrorCodeEnum.HIBERNATE_CREATE_FAILURE, censusMasterIngest.getCurrentSegmentNo());
                }
                return censusSegmentId;
        }
        /**
         * 
         * @param session
         * @param response
         * @return created or updated record id
         */
        protected String retrieveOrStoreCensusMasterIngest(Session session, Element response) {
        		
        		CensusMasterIngest censusMasterIngest = new CensusMasterIngest();
                String lastSegment = response.element("segment").element("last").getText();
                censusMasterIngest.setCensusExpectedCount(lastSegment);
                
                String segmentDatetime = response.element("segment").element("datetime").getText();
                censusMasterIngest.setSegmentDatetime(segmentDatetime);
               
                List<Element> patientsList = response.elements("patient");
		        Element patient = (Element) patientsList.get(0);
		        String vendorName = patient.element("censusSurveyResponse").element("vendor").element("name").getText();
		        censusMasterIngest.setVendorName(vendorName);
		        
		        String vendorFacility = patient.element("censusSurveyResponse").element("vendor").element("number").getText();
		        censusMasterIngest.setVendorFacility(vendorFacility);
		        
//		        Element reportStartDateElement = (Element) patient.element("censusSurveyResponse").element("reportStartDate").clone();
		        String reportStartDate = patient.element("censusSurveyResponse").element("reportStartDate").getText();
		        
		        censusMasterIngest.setReportStartDatetime(reportStartDate);
		        
//		        censusMasterIngest.setReportStartDatetime(reportStartDatetime)
		        return performCUADOnCensusMasterIngest(session, censusMasterIngest);
		        
        }
        /**
         * 
         * @param session
         * @param censusMasterIngest
         * @return newly inserted record ID
         */
        private String performCUADOnCensusMasterIngest(Session session, CensusMasterIngest censusMasterIngest){
        	
        	 	List<Element> results = null;
                String status = CensusSurveyConstant.INGEST_PENDING;
                String censusMasterID = null;
        	 	Element incomingCensusElement= DocumentHelper.createElement("censusMasterIngest");
                
                Element segmentExpectedCountElement= DocumentHelper.createElement("segmentExpectedCount");
                
                segmentExpectedCountElement.setText(censusMasterIngest.getCensusExpectedCount());
                
                incomingCensusElement.add(segmentExpectedCountElement);
                
                incomingCensusElement.addElement("datetime").addText(censusMasterIngest.getSegmentDatetime());
                
                incomingCensusElement.addElement("vendorName").addText(censusMasterIngest.getVendorName());
		        		       
		        incomingCensusElement.addElement("vendorFacility").addText(censusMasterIngest.getVendorFacility());
                       
                incomingCensusElement.addElement("reportStartDate").addText(censusMasterIngest.getReportStartDatetime());

                
                //System.out.println("incomingCensusElement *****************************:" + incomingCensusElement.asXML() + "*****************\n");              
                
                Criteria criteria = session.createCriteria("censusMasterIngest");
                criteria.add(Example.create(incomingCensusElement));
                
                try {
                		results = criteria.list();
                } catch (org.hibernate.exception.GenericJDBCException e) {
                       	throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
                }
                
                Element segmentReceivedCountElement= DocumentHelper.createElement("segmentReceivedCount");

                
                if (results.size() < 1) {
                        segmentReceivedCountElement.setText("1");
                        incomingCensusElement.add(segmentReceivedCountElement);
                       
                        if( censusMasterIngest.getIngestStatus() != null){
                        	status = censusMasterIngest.getIngestStatus();
                        }else if ("1".equals(censusMasterIngest.getCensusExpectedCount())){
                        	status = CensusSurveyConstant.INGEST_COMPLETE;
                        }
                        
                        incomingCensusElement.addElement("ingestStatus").addText(status);
                        
                        censusMasterID = session.save(incomingCensusElement).toString();
                } else {
                                
                        String ingestStatus = results.get(0).element("ingestStatus").getText();

                        if(ingestStatus.equals(CensusSurveyConstant.INGEST_PENDING)){
                                int segmentReceivedCount = Integer.parseInt(results.get(0).element("segmentReceivedCount").getText()) + 1;
                                results.get(0).element("segmentReceivedCount").setText(Integer.toString(segmentReceivedCount));
                                if( censusMasterIngest.getIngestStatus() != null){
                                	status = censusMasterIngest.getIngestStatus();
                                } else if (results.get(0).element("segmentReceivedCount").getText().equals(censusMasterIngest.getCensusExpectedCount())){
                                	status = CensusSurveyConstant.INGEST_COMPLETE;
                                } 
                                
                                results.get(0).element("ingestStatus").setText(status);
                                
                        
                                System.out.println("DB Element outgoing:" + results.get(0).asXML() + "\n");
                                censusMasterID = results.get(0).elementText("id");
                                session.update(results.get(0));
                        } else if (ingestStatus.equals(CensusSurveyConstant.INGEST_COMPLETE)){
                                //Census Status is complete
 //                               throw new ReadException(ErrorCodeEnum.HIBERNATE_CREATE_FAILURE, segmentDateTime );
                        } else {
                                        //Previous Segment had FAILED
//                                        throw new ReadException(ErrorCodeEnum.HIBERNATE_CREATE_FAILURE, segmentDateTime );
                        }
                }
                return censusMasterID;
        }
                

                
        /**
        * Sets the rules to evaluate to determine if the persistence manager is
        * applicable for the request.
        * 
         * @param rules
        *            The boolean rules to be evaluated.
        */
        public void setRules(List<BooleanRuleInterface> rules) {
                        this.rules = rules;
        }

        public void setCdsAppName(String cdsAppName) {
                        this.cdsAppName = cdsAppName;
        }
            	
        private void iterateAllElements(List<Element> elementList){
    		
	    	Iterator<Element> it = elementList.iterator();
	    	while (it.hasNext()){
	    		Element rootElement = it.next();
	    		String rootName = rootElement.getName();
	    		String rootText = rootElement.getText();
	    		Iterator<Element> elementIter =  rootElement.elementIterator();
	    		while(elementIter.hasNext()){
	    			Element element = elementIter.next();
	    			String name = element.getName();
	    			String text = element.getText();
	    			System.out.println("");
	    		}
	    	}
    	
    	}
                
                /* ===================Following is for the multi-table relational solution
                @SuppressWarnings("unchecked")
                private void storeModalities(Session session, Element aSurveyResponse) {
                                List<Element> results = null;

                                try {
                                                                Element responseModalities = aSurveyResponse.element("modalities");
                                                                Iterator<Element> it =  responseModalities.elementIterator();
                
                                                while (it.hasNext())
                                                {                              
                                                                Element responseModality = (Element) it.next();
                                                                Criteria criteria;
                                                                criteria = session.createCriteria("modality");
                                                                criteria.add(Example.create(responseModality));
                                                                Element aModalitiy;
                                                                
                                                                try {
                                                                                results = criteria.list();
                                                                } catch (org.hibernate.exception.GenericJDBCException e) {
                                                                                throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e,
                                                                                                                e.getMessage());
                                                                }

                                                                if (results.size() < 1) {
                                                                                // Modality doesn't exist
                                                                                aModalitiy = (Element)responseModality.clone();
                                                                                aModalitiy.detach();
                                                                                session.save(aModalitiy);
                                                                }
                                                                else{
                                                                                
                                                                                aModalitiy = results.get(0);
                                                                                aModalitiy.detach();
                                                                }
                                                                                responseModality.add(aModalitiy);
                                                                                responseModality.remove(responseModality.element("modalityType"));
                                                                                responseModality.remove(responseModality.element("modalityName"));

                                                                //System.out.println("aModality:" + responseModalities.asXML() + "\n");           
                                                }                              
                                } catch (org.hibernate.exception.GenericJDBCException e) {
                                                throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e,
                                                                                e.getMessage());
                                }
                }
                
                @SuppressWarnings("unchecked")
                protected void retrieveOrStoreData(Session session, Element response,
                                                String entityName) {
                                List<Element> results = null;
                                Element transitive = response.element(entityName);
                                if(surveyPatient.equalsIgnoreCase(entityName)){
                                                String vendorId = response.element("vendor").elementText("id");
                                                transitive.addElement("vendorID").addText(vendorId);
                                }
                
                                Criteria criteria = session.createCriteria(entityName);
                                criteria.add(Example.create(transitive));
                                try {
                                                results = criteria.list();
                                } catch (org.hibernate.exception.GenericJDBCException e) {
                                                throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e,
                                                                                e.getMessage());
                                }
                                
                                if (results.size() < 1) {

                                                session.save(transitive);
                                } else {
                                                response.remove(transitive);
                                                response.add(results.get(0));
                                }
                }
                
                @SuppressWarnings("unchecked")
                protected void validateAndRetrieveCCFacility(Session session,
                                                Element aSurveyResponse) {

                                String incomingFacilityNumber = aSurveyResponse.element("careCoordinator").element("facilityNumber").getText();
                                Element incomingFacility = DocumentHelper.createElement("facility");
                                Element locationElement = DocumentHelper.createElement("location");
                                locationElement.setText(incomingFacilityNumber);
                                incomingFacility.add(locationElement);
                                List<Element> results = null;       

                                Criteria criteria = session.createCriteria("facility");
                                criteria.add(Example.create(incomingFacility));

                                try {
                                                results = criteria.list();
                                } catch (org.hibernate.exception.GenericJDBCException e) {
                                                throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e,
                                                                                e.getMessage());
                                }

                                if (results.size() != 1) {
                                                throw new ReadException(
                                                                                ErrorCodeEnum.WRITE_REQUEST_CARE_COORDINATOR_FACILITY_INVALID,
                                                                                incomingFacility.elementText("location"));
                                }
                                //add Facility ID to insert in the Care Coordinator table.
                                String facilityId = results.get(0).elementText("id");
                                aSurveyResponse.element("careCoordinator").addElement("facilityID").addText(facilityId);
                }
                
                                @SuppressWarnings("unchecked")
                protected void validateAndRetrieveCensusVendor(Session session,
                                                Element aSurveyResponse) {
                                List<Element> results = null;
                                boolean foundVendor = false;

                                Element incomingVendor = aSurveyResponse.element("vendor");

                                Element vendorName = incomingVendor.element("name");
                                String vendorNameToStore = vendorName.getText();

                                incomingVendor.remove(vendorName);

                                Criteria criteria = session.createCriteria("vendor");
                                criteria.add(Example.create(incomingVendor));
                                try {
                                                results = criteria.list();
                                } catch (org.hibernate.exception.GenericJDBCException e) {
                                                throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e,
                                                                                e.getMessage());
                                }

                                if (results.size() < 1) {
                                                // vendor number doesn't exist
                                                throw new ReadException(
                                                                                ErrorCodeEnum.WRITE_REQUEST_SURVEY_VENDOR_NUMBER_INVALID,
                                                                                incomingVendor.element("number").getText());
                                }

                                for (Element vendor : results) {
                                                if (vendor.element("name").getText()
                                                                                .equals(vendorNameToStore)) {
                                                                aSurveyResponse.remove(incomingVendor);
                                                                aSurveyResponse.add(vendor);
                                                                foundVendor = true;
                                                                break;
                                                }
                                }

                                if (!foundVendor) {
                                                incomingVendor.add(vendorName);
                                                session.save(incomingVendor);
                                }
                }
                ========================================*/
    

    
}
