/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/**
 * @author vhaislegberb
 * 
 * Query parameter setter for taking an incoming Calendar object, converting it into a Timestamp object, and then
 * setting it in the parameter map to be used during the query process.
 *
 */
public class TimestampQueryParameterTransformer
    implements
        QueryParameterTransformerInterface
{

    /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterSetterInterface#setParameter(java.lang.String, java.lang.Object, java.util.Map)
     */
    @Override
    public void transformAndSetParameter( String parameterName, Object parameterValue, Map<String, Object> parameterMap )
    {
        
        parameterMap.put( parameterName, transform(parameterValue));

    }

    @Override
    public Object transform( Object parameterValue )
    {
        if( !(parameterValue instanceof Calendar))
        {
            throw new IllegalArgumentException("PointInTimeQueryParameterSetter only supports parameter values of type Calendar.");
        }
        
        Calendar date = (Calendar)parameterValue;
        return new Timestamp(date.getTimeInMillis());
    }

}
