/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;

/**
 * @author vhaislegberb
 *
 * Interface for defining the contract between the Query Work objects and the the implementors which
 * can construct a Query Name from input parameters such as the Entry Filters.
 */
public interface QueryNameBuilderInterface
{
    /**
     * Build the query name for the association name and the entry filter.
     * @param entryFilter The entry filter which contains information about what is being queried.
     * @param associationName The association name qualifier which is used for domains which required
     * multiple queries to read in an observation for a patient.
     * @return The name of the named query to used for retrieving the information.
     */
    String buildQueryName( EntryFilterInterface entryFilter, String associationName );
}
