

package gov.va.med.cds.persistence.hibernate;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.PersistenceException;


/**
 * Handles exceptions thrown by hibernate read for modifications.
 * 
 */
public class IdentityException
    extends
        PersistenceException
{
    private static final long serialVersionUID = 6846286678032262411L;


    /**
     * Parent constructor for hibernate read for modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public IdentityException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for hibernate read for modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public IdentityException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for hibernate read for modifications
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public IdentityException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }

}
