/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;

import java.util.Map;

/**
 * @author vhaislegberb
 *
 * Interface that facilitates the contract that the Query Work instances use to extract
 * query parameter names and values from the Entry Filter instances.
 */
public interface FilterParameterExtractorInterface
{
    // PN_ Prefix stands for Parameter Name (PN)
    static final String PN_PERSON_IDENTIFIERS = "pids";
    
    static final String PN_RECORD_IDENTIFIERS = "recordIdentifiers";
    
    static final String PN_START_DATE = "startDate";
    
    static final String PN_END_DATE = "endDate";
    
    static final String PN_DATE = "anyDate";
    
    static final String PN_XPATH_FILTER_EXPRESSION = "xpathFilterExpression";
    
    static final String PN_XPATH_FILTER_EXPRESSION_NAMESPACE = "xpathFilterExpressionNamespace";
    
    /**
     * 
     * @param parameterExtractorMap A map of parameters to parameter transformers provided from the query work instance. 
     * @param entryFilter The entry filter instance to extract the parameter names and values from.
     * @return The Map of parameter names to values.
     */
    Map<String, Object> extractNamedParameters( Map<String, QueryParameterTransformerInterface> parameterTransformerMap, EntryFilterInterface entryFilter );
}
