

package gov.va.med.cds.persistence.hibernate;


import java.util.Map;

import gov.va.med.cds.persistence.AbstractPersistenceManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;


public abstract class AbstractHibernatePersistenceManager
    extends
        AbstractPersistenceManager
{

    protected static final Log LOGGER = LogFactory.getLog( AbstractHibernatePersistenceManager.class );
    
    private Map<String, SessionFactory> sessionFactoryMap;


    /**
     * Sets the session factory map with maps template identifiers to session factory instances.
     * 
     * @param sessionFactoryMap session factory passed in from spring injection.
    */
    final public void setSessionFactoryMap( Map<String, SessionFactory> sessionFactoryMap )
    {
        this.sessionFactoryMap = sessionFactoryMap;
    }
    
    
    final SessionFactory getSessionFactory( String templateId )
    {
        SessionFactory sessionFactory = this.sessionFactoryMap.get( templateId );
        if( sessionFactory == null )
        {
            throw new IllegalArgumentException( String.format("No session factory for template identifier '%s' found.", templateId) );
        }
        
        return sessionFactory;
    }
    
}
