package gov.va.med.cds.persistence;

import java.util.List;

import org.dom4j.Element;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.exception.CensusException;
import gov.va.med.cds.persistence.hibernate.WriteableCensusSurveyPersistenceManager;
import gov.va.med.cds.valueobject.CensusMasterIngest;

/**
 * @author barryegbert
 * 
 */
public interface WritePersistenceManagerInterface
    extends
        PersistenceManagerInterface
{

    /**
     * Handles the CUAD requests and applies the transaction to the data-source as directed by the request type.
     * 
     * @param templateId The identifier of the template being created, updated, appended, or deleted.
     * @param requestType - request type could be Create, Update, Append and Delete.
     * @param object - CDM objects to apply to the data-source.
     */
    String performCUADOnClinicalData( String templateId, Operation requestType, Object object, String domainEntryPoint )
        throws PersistenceException;


    /**
     * Handles the CUAD requests and applies the transaction to the data-source as directed by the request type.
     * 
     * @param templateId The identifier of the template being created, updated, appended, or deleted.
     * @param requestType - request type could be Create, Update, Append and Delete.
     * @param object - CDM objects to apply to the data-source.     */
    String performCUADOnPatientsData( String templateId, String requestId, Operation requestType, Object object, DomainEntryPoint domainEntryPoint )
        throws PersistenceException;


    /**
     * Method used to determine if persistence manager is applicable for the criteria data passed as a parameter.
     * 
     * @param critera Meta data used to determine if this persistence manager is applicable for the operation,
     *            type of data, and template specified.
     * @return True if applicable; otherwise false.
     * @throws PersistenceException If problems occur while determining applicability.
     */
    boolean isApplicable( Object criteria )
        throws PersistenceException;
    
    
    public List<Element> performReadOnCensusMetaData(CensusMasterIngest censusMasterIngest) throws CensusException;

	
	public String performCUADOnCensusMetaData(Operation aOperation, CensusMasterIngest censusMasterIngest) throws PersistenceException;
    
}
