

package gov.va.med.cds.persistence;


import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.hibernate.VistaStoredProcedureQueryWork;
import gov.va.med.cds.response.strategy.VistaStoredProcedureResponseStrategyInterface;

import java.util.List;
import java.util.Map;

import org.hibernate.Session;


public class VistaStoredProcedureBasedQueryStrategy
    extends
        DefaultAssociationBasedQueryStrategy
{
    protected VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy;
    protected Map<String, String> queryMap;
    protected Map<String, String> templateTimeoutMap;
    protected PooledConnectionUnwrapperInterface pooledConnectionUnwrapper;


    @Override
    protected QueryWorkInterface createQueryWork( Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, List<String> personIdentifiers,
                    Class<?> pointInTimeUserType, String siteId )
    {

        VistaStoredProcedureQueryWork queryWork = new VistaStoredProcedureQueryWork( session, queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, queryMap,
                        vistaResponseStrategy, applicationName, siteId );
        queryWork.setTemplateTimeoutMap( templateTimeoutMap );
        queryWork.setVistaResponseStrategy( vistaResponseStrategy );
        queryWork.setQueryMap( queryMap );
        queryWork.setPooledConnectionUnwrapper( pooledConnectionUnwrapper );
        return queryWork;
    }


    public void setVistaResponseStrategy( VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy )
    {
        this.vistaResponseStrategy = vistaResponseStrategy;
    }


    public void setQueryMap( Map<String, String> queryMap )
    {
        this.queryMap = queryMap;
    }


    public void setTemplateTimeoutMap( Map<String, String> templateTimeoutMap )
    {
        this.templateTimeoutMap = templateTimeoutMap;
    }


    public void setPooledConnectionUnwrapper( PooledConnectionUnwrapperInterface pooledConnectionUnwrapper )
    {
        this.pooledConnectionUnwrapper = pooledConnectionUnwrapper;
    }
}
