/**
 * 
 */
package gov.va.med.cds.persistence;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.hibernate.VistaGenericStoredProcedureQueryWork;
import gov.va.med.cds.response.strategy.VistaGenericStoredProcedureResponseStrategyInterface;

import org.hibernate.Session;

import java.util.List;

/**
 * @author vhaislegberb
 *
 * Creates a specialized query work object that that knows how to build 
 * a VistA Generic Stored Procedure request.
 */
public class VistaGenericStoredProcedureBasedQueryStrategy extends
		VistaStoredProcedureBasedQueryStrategy {
	
	private String username;
	
	private String password;
	
	private String rpcName;
	
	private VistaGenericStoredProcedureResponseStrategyInterface vistaGenericResponseStrategy;

	@Override
    protected QueryWorkInterface createQueryWork( Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, List<String> personIdentifiers,
                    Class<?> pointInTimeUserType, String siteId )
    {

        VistaGenericStoredProcedureQueryWork queryWork = new VistaGenericStoredProcedureQueryWork( session, queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, queryMap,
                        vistaGenericResponseStrategy, applicationName, siteId, username, password, rpcName );
        queryWork.setTemplateTimeoutMap( templateTimeoutMap );
        queryWork.setQueryMap( queryMap );
        queryWork.setPooledConnectionUnwrapper( pooledConnectionUnwrapper );
        return queryWork;
    }
	
	public void setUsername(String username) {
		this.username = username;
	}
	
	public void setPassword(String password) {
		this.password = password;
	}
	
	public void setRpcName(String rpcName) {
		this.rpcName = rpcName;
	}

    public void setVistaGenericResponseStrategy( VistaGenericStoredProcedureResponseStrategyInterface vistaGenericResponseStrategy )
    {
        this.vistaGenericResponseStrategy = vistaGenericResponseStrategy;
    }

}
