

package gov.va.med.cds.persistence;


//TODO: refactor to implement reads from HDR II that will map directly to xml

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.filter.EntryFilterInterface;

import org.dom4j.Document;

import java.util.List;


/**
 * @author barryegbert
 * 
 */
public interface ReadPersistenceManagerInterface
    extends
        PersistenceManagerInterface
{

    /**
       * Handles the read requests.
       * 
       * @param entryFilter - persistence filter.
       * @param personIdentifiers List of person identifiers
       * @return List of clinical data documents.
       * @throws PersistenceException
       */
    Document performReadOnClinicalData( EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers, String applicationName )
        throws PersistenceException;


    /**
       * Method used to determine if the persistence manager is applicable to the CDS persistence filter 
       * and person identifiers passed as parameters.
       * 
       * @param entryFilter The filter containing the information necessary for the persistence manager to
       * determine its applicability to the request.
       * @param personIdentifiers The list of person identifiers that the incoming query is attempting to 
       * pull data for. 
       * @return True if the persistence manager is applicable; otherwise false.
       * @throws PersistenceException if problems occur while determining applicability.
       */
    boolean isApplicable( EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers )
        throws PersistenceException;


    String getSiteIdentifier( );

}
