

package gov.va.med.cds.persistence;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.filter.EntryFilterInterface;

import org.dom4j.Element;

import java.util.Collection;
import java.util.List;
import java.util.Set;


/**
 * 
 * Stores the configured settings in Map for different databases through Hibernate
 * 
 */
public interface PersistenceLocatorInterface
{
    /**
     * Returns the writeable persistence manager applicable for the type of data to be written.
     * 
     * @param domainEntryPoints The domain entry point to use to determine the appropriate write persistence manager to return.
     * @return The write persistence manager that is applicable for the domain entry point passed in.
     * @throws PersistenceException If there is no persistence manager found when trying to resolve the proper persistence manager for the
     *             template meta data
     */
    WritePersistenceManagerInterface getWritePersistenceManager( DomainEntryPoint domainEntryPoint )
        throws PersistenceException;


    /**
     * Gets the list of readable persistence managers that are applicable for the CDS entry filter and the person identifiers.
     * @param entryFilter The entry filter for the read request.
     * @param personIdentifiers The list of person identifiers to be queried.
     * @return The list of persistence managers.
     */
    List<ReadPersistenceManagerInterface> getReadPersistenceManagers( EntryFilterInterface entryFilter,
                    List<PersonIdentifierInterface> personIdentifiers );


}
