

package gov.va.med.cds.persistence;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;

import java.util.ArrayList;
import java.util.List;


/**
 * 
 * Stores the configured settings in Map for different databases through Hibernate
 * 
 */

public class PersistenceLocator
    implements
        PersistenceLocatorInterface
{
    private List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>(); // injected


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.PersistenceLocatorInterface#getWritePersistenceManager(java.util.Set)
     */
    public WritePersistenceManagerInterface getWritePersistenceManager( DomainEntryPoint domainEntryPoint )
        throws PersistenceException
    {
        // Iterate over the list and checking each persistence manager to see if it is both writable and applicable.
        for ( PersistenceManagerInterface pm : persistenceManagers )
        {
            if ( pm instanceof WritePersistenceManagerInterface )
            {
                WritePersistenceManagerInterface wpm = ( WritePersistenceManagerInterface )pm;
                if ( wpm.isApplicable( domainEntryPoint ) )
                {
                    return wpm;
                }
            }
        }

        // If no writeable persistence manager is found that is applicable for the type, throw an exception
        throw new PersistenceException( ErrorCodeEnum.UNABLE_TO_RESOLVE_WRITEABLE_PERSISTENCE_MANAGER_FAILURE );
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.PersistenceLocatorInterface#getReadPersistenceManagers(gov.va.med.cds.filter.EntryFilterInterface, java.util.List)
     */
    public List<ReadPersistenceManagerInterface> getReadPersistenceManagers( EntryFilterInterface entryFilter,
                    List<PersonIdentifierInterface> personIdentifiers )
    {
        List<ReadPersistenceManagerInterface> readablePersistenceManagers = new ArrayList<ReadPersistenceManagerInterface>();

        for ( PersistenceManagerInterface pm : persistenceManagers )
        {
            if ( pm instanceof ReadPersistenceManagerInterface )
            {
                ReadPersistenceManagerInterface rpm = ( ReadPersistenceManagerInterface )pm;
                if ( rpm.isApplicable( entryFilter, personIdentifiers ) )
                {
                    readablePersistenceManagers.add( ( ReadPersistenceManagerInterface )pm );
                }
            }
        }
        return readablePersistenceManagers;
    }


    /**
     * Set the persistnece managers list.
     * 
     * @param persistenceManagers The List of persisence managers know by the locator.
     */
    public void setStaticPersistenceManagers( List<PersistenceManagerInterface> persistenceManagers )
    {
        this.persistenceManagers.addAll( persistenceManagers );
    }


    public void setDynamicPersistenceManagers( List<PersistenceManagerInterface> persistenceManagers )
    {
        this.persistenceManagers.addAll( persistenceManagers );
    }

}
