

package gov.va.med.cds.persistence;


import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;


/**
 * Handles exceptions thrown by persistence classes.
 * 
 */
public class PersistenceException
    extends
        AbstractCdsBaseException
{

    private static final long serialVersionUID = 4783429399489832692L;


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public PersistenceException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public PersistenceException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public PersistenceException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }

}
