

package gov.va.med.cds.filter;


import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;

import java.util.Set;

import javax.xml.validation.Schema;


/**
 * This class creates an in memory cache of Filter Schemas for the Filter package. It keeps these schemas in a map.
 * 
 */
public interface FilterMemoryCacheInterface
{
    /**
     * Loads the map with the given pair of filterId and filterMetadata.
     * 
     * @param filterId
     * @param filterMetaData
     */
    void loadFilterMetaDataIntoMemoryCache( String filterId, FilterMetaDataInterface filterMetaData );


    /**
     * Gets the schema string for the filter from the filterMetaData.
     * 
     * @param filterId
     * @return filter schema validator
     */
    String getFilterString( String filterId );


    /**
     * Gets the schema for the filter from the filterMetaData.
     * 
     * @param filterId
     * @return filter schema validator
     */
    Schema getFilterSchema( String filterId );


    /**
     * @return True if the Filter Memory Cache map is empty.
     */
    boolean isEmpty( );


    /**
     * Clears the Filter Memory Cache map.
     */
    void clear( );


    /**
     * Resizes the Filter Memory Cache map to the given size.
     * 
     * @param newSize
     */
    void reSize( int newSize );


    /**
     * Gets the no. of schemas contained in Filter Memory Cache map.
     * 
     * @return number of filter schemas
     */
    int getNumberOfFilterSchemasLoadedIntoFilterCache( );


    /**
     * Gets the size of Filter Memory Cache threshold.
     * 
     * @return filterCacheThreshold value
     */
    int getFilterCacheThreshold( );


    /**
     * gets available list of filterIds in filter cache
     * 
     * @return Set of filterIds
     */
    Set<String> getFilterCacheFilterIds( );
}
