

package gov.va.med.cds.filter;


import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;

import java.util.Collection;
import java.util.List;



/**
 * This class is the public interface for handling the persistence (database) for the Filter Cache information. The
 * Filter Cache contains an XML schema which is used to validate the filters that are sent by the clients. In this way
 * we can prevent any security risks that were associated when any valid filter would be accepted and executed
 * previously.
 * 
 */
public interface FilterCachePersistenceInterface
{
    /**
     * Persists the given Filter Schema to the database.
     * 
     * @param filterMetaData
     */
    void persistFilterSchema( FilterMetaDataInterface filterMetaData );


    /**
     * Loads all the existing Filters Schemas from the database into the given Filter Memory Cache.
     * 
     * @param filterMemoryCacheInterface
     */
    void loadAllFilterSchemasIntoMemoryCache( FilterMemoryCacheInterface filterMemoryCacheInterface );


    /**
     * Loads the filter information retrieved from the database based on a given filterid into Filter Memory Cache.
     * 
     * @param filterId
     * @param filterCache
     */
    void loadFilterIntoMemoryCache( String filterId, FilterMemoryCacheInterface filterCache );


    /**
     * Removes a Filter Schema from the database based on filterid. This method enables certain kinds of tests.
     * 
     * @param filterId
     */
    void removeFilterSchema( String filterId );


    /**
     * This method replaces the contents of the database.
     * 
     * Note: This method is only used for testing.
     * 
     * @param filterMetaDatas
     * @param domainEntryPointsList
     * @param vhimVersionList
     */
    void replaceFilterPersistence( Collection<FilterMetaDataInterface> filterMetaDatas );


    /**
     * This method returns the FilterIdentifiers.
     * 
     * @return List<String>
     */
    List<String> getFilterIdentifiers( );

}
